/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.transaction;

import net.hasor.dbvisitor.transaction.Isolation;
import net.hasor.dbvisitor.transaction.Propagation;
import net.hasor.dbvisitor.transaction.TransactionCallback;
import net.hasor.dbvisitor.transaction.TransactionManager;
import net.hasor.dbvisitor.transaction.TransactionStatus;
import net.hasor.dbvisitor.transaction.TransactionTemplate;

public class TransactionTemplateManager
implements TransactionTemplate {
    private final TransactionManager transactionManager;

    public TransactionTemplateManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public <T> T execute(TransactionCallback<T> callBack, Propagation behavior, Isolation level) throws Throwable {
        TransactionStatus tranStatus = null;
        try {
            tranStatus = this.transactionManager.begin(behavior, level);
            T t = callBack.doTransaction(tranStatus);
            return t;
        }
        catch (Throwable e) {
            if (tranStatus != null) {
                tranStatus.setRollback();
            }
            throw e;
        }
        finally {
            if (tranStatus != null && !tranStatus.isCompleted()) {
                this.transactionManager.commit(tranStatus);
            }
        }
    }
}

