/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.types.handler;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import net.hasor.cobble.NumberUtils;
import net.hasor.cobble.io.IOUtils;
import net.hasor.dbvisitor.types.handler.AbstractTypeHandler;

public class NumberTypeHandler
extends AbstractTypeHandler<Number> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Number parameter, Integer jdbcType) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number getNullableResult(final ResultSet rs, final String columnName) throws SQLException {
        return this.getResultSetValue(new NumberResultValue(){

            @Override
            public String getColumnClassName() throws SQLException {
                return this.getObject().getClass().getName();
            }

            @Override
            public Timestamp getTimestamp() throws SQLException {
                return rs.getTimestamp(columnName);
            }

            @Override
            public java.sql.Date getDate() throws SQLException {
                return rs.getDate(columnName);
            }

            @Override
            public Object getObject() throws SQLException {
                return rs.getObject(columnName);
            }
        });
    }

    @Override
    public Number getNullableResult(final ResultSet rs, final int columnIndex) throws SQLException {
        return this.getResultSetValue(new NumberResultValue(){

            @Override
            public String getColumnClassName() throws SQLException {
                return rs.getMetaData().getColumnClassName(columnIndex);
            }

            @Override
            public Timestamp getTimestamp() throws SQLException {
                return rs.getTimestamp(columnIndex);
            }

            @Override
            public java.sql.Date getDate() throws SQLException {
                return rs.getDate(columnIndex);
            }

            @Override
            public Object getObject() throws SQLException {
                return rs.getObject(columnIndex);
            }
        });
    }

    @Override
    public Number getNullableResult(final CallableStatement cs, final int columnIndex) throws SQLException {
        return this.getResultSetValue(new NumberResultValue(){

            @Override
            public String getColumnClassName() throws SQLException {
                return cs.getMetaData().getColumnClassName(columnIndex);
            }

            @Override
            public Timestamp getTimestamp() throws SQLException {
                return cs.getTimestamp(columnIndex);
            }

            @Override
            public java.sql.Date getDate() throws SQLException {
                return cs.getDate(columnIndex);
            }

            @Override
            public Object getObject() throws SQLException {
                return cs.getObject(columnIndex);
            }
        });
    }

    protected Number getResultSetValue(NumberResultValue rs) throws SQLException {
        Object obj = rs.getObject();
        if (obj == null) {
            return null;
        }
        String className = obj.getClass().getName();
        if (obj instanceof Number) {
            return (Number)obj;
        }
        if (obj instanceof Timestamp) {
            return ((Timestamp)obj).getTime();
        }
        if (obj instanceof java.sql.Date) {
            return ((java.sql.Date)obj).getTime();
        }
        if (obj instanceof Time) {
            return ((Time)obj).getTime();
        }
        if ("oracle.sql.TIMESTAMP".equals(className) || "oracle.sql.TIMESTAMPTZ".equals(className)) {
            return rs.getTimestamp().getTime();
        }
        if (className.startsWith("oracle.sql.DATE")) {
            String metaDataClassName = rs.getColumnClassName();
            if ("java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName)) {
                return rs.getTimestamp().getTime();
            }
            return rs.getDate().getTime();
        }
        if (obj instanceof Date) {
            return ((Date)obj).getTime();
        }
        String stringValue = null;
        if (obj instanceof String) {
            stringValue = (String)obj;
        } else if (obj instanceof Clob) {
            try {
                StringWriter writer = new StringWriter();
                IOUtils.copy((Reader)((Clob)obj).getCharacterStream(), (Writer)writer);
                stringValue = writer.toString();
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        } else {
            stringValue = obj.toString();
        }
        stringValue = stringValue.trim();
        if (!NumberUtils.isNumber((String)stringValue)) {
            throw new SQLException("Cannot convert String to Number.");
        }
        return NumberUtils.createNumber((String)stringValue);
    }

    protected static interface NumberResultValue {
        public String getColumnClassName() throws SQLException;

        public Timestamp getTimestamp() throws SQLException;

        public java.sql.Date getDate() throws SQLException;

        public Object getObject() throws SQLException;
    }
}

