/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.types.handler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import net.hasor.cobble.io.IOUtils;
import net.hasor.dbvisitor.types.handler.AbstractTypeHandler;

public class SqlXmlForReaderTypeHandler
extends AbstractTypeHandler<Reader> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Reader parameter, Integer jdbcType) throws SQLException {
        SQLXML sqlxml = ps.getConnection().createSQLXML();
        try (OutputStream writer = sqlxml.setBinaryStream();){
            BufferedReader reader = new BufferedReader(parameter);
            String body = null;
            while ((body = reader.readLine()) != null) {
                writer.write(body.getBytes());
            }
            writer.flush();
            ps.setSQLXML(i, sqlxml);
        }
        catch (IOException e) {
            throw new SQLException("Error copy xml data to SQLXML for parameter #" + i + " with JdbcType " + jdbcType + ", Cause: " + e.getMessage(), e);
        }
        finally {
            sqlxml.free();
        }
    }

    @Override
    public Reader getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.sqlXmlToStream(rs.getSQLXML(columnName));
    }

    @Override
    public Reader getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.sqlXmlToStream(rs.getSQLXML(columnIndex));
    }

    @Override
    public Reader getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.sqlXmlToStream(cs.getSQLXML(columnIndex));
    }

    protected Reader sqlXmlToStream(SQLXML sqlxml) throws SQLException {
        if (sqlxml == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        try (Reader reader = sqlxml.getCharacterStream();){
            IOUtils.copy((Reader)reader, (Writer)sw);
        }
        catch (IOException e) {
            throw new SQLException("read chars Xml Data failed : " + e.getMessage(), e);
        }
        finally {
            sqlxml.free();
        }
        return new StringReader(sw.toString());
    }
}

