/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.types.handler.pg;

import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.hasor.cobble.codec.HexUtils;
import net.hasor.dbvisitor.types.handler.ArrayTypeHandler;
import net.hasor.dbvisitor.types.handler.pg.PgMoneyAsBigDecimalTypeHandler;

public class PgArrayTypeHandler
extends ArrayTypeHandler {
    protected final String elementType;
    protected final PostgresReadArrayHandler readArrayHandler;

    public PgArrayTypeHandler(String elementType, int dimCount) {
        this.elementType = elementType;
        this.readArrayHandler = this.createPostgresReadArrayHandler(elementType);
    }

    public PgArrayTypeHandler(String elementType, PostgresReadArrayHandler readArrayHandler) {
        this.elementType = elementType;
        this.readArrayHandler = readArrayHandler;
    }

    protected PostgresReadArrayHandler createPostgresReadArrayHandler(String elementType) {
        switch (elementType) {
            case "money": {
                return rs -> PgMoneyAsBigDecimalTypeHandler.toNumber(rs.getString("VALUE"));
            }
            case "bit": 
            case "varbit": 
            case "geometry": {
                return rs -> rs.getString("VALUE");
            }
            case "bytea": {
                return rs -> rs.getBytes("VALUE");
            }
        }
        return rs -> rs.getObject("VALUE");
    }

    protected Object[] objects(Object parameter) {
        Object[] oriData = (Object[])parameter;
        ArrayList<Object> copy = new ArrayList<Object>();
        for (Object oriDatum : oriData) {
            if (this.elementType.equals("bytea")) {
                copy.add(HexUtils.bytes2hex((byte[])((byte[])oriDatum)));
                continue;
            }
            copy.add(oriDatum);
        }
        return copy.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, Integer jdbcType) throws SQLException {
        if (parameter instanceof Array) {
            ps.setArray(i, (Array)parameter);
        } else {
            Array array = null;
            try {
                array = ps.getConnection().createArrayOf(this.elementType, this.objects(parameter));
                ps.setArray(i, array);
            }
            finally {
                if (array != null) {
                    array.free();
                }
            }
        }
    }

    @Override
    protected Object extractArray(Array array) throws SQLException {
        if (array == null) {
            return null;
        }
        ArrayList<Object> data = new ArrayList<Object>();
        try (ResultSet rs = array.getResultSet();){
            while (rs.next()) {
                if (this.readArrayHandler == null) {
                    data.add(rs.getObject("VALUE"));
                    continue;
                }
                data.add(this.readArrayHandler.readElement(rs));
            }
            array.free();
            Object[] objectArray = data.toArray();
            return objectArray;
        }
    }

    public static interface PostgresReadArrayHandler {
        public Object readElement(ResultSet var1) throws SQLException;
    }
}

