/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.hasor.utils.StringUtils;
import net.hasor.utils.convert.ConverterUtils;

public class BeanUtils {
    public static Object getDefaultValue(Class<?> returnType) {
        if (returnType == null || !returnType.isPrimitive()) {
            return null;
        }
        if (returnType == Integer.TYPE) {
            return 0;
        }
        if (returnType == Byte.TYPE) {
            return (byte)0;
        }
        if (returnType == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (returnType == Double.TYPE) {
            return 0.0;
        }
        if (returnType == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (returnType == Long.TYPE) {
            return 0L;
        }
        if (returnType == Short.TYPE) {
            return (short)0;
        }
        if (returnType == Boolean.TYPE) {
            return false;
        }
        if (returnType == Void.TYPE) {
            return null;
        }
        if (returnType.isArray()) {
            return null;
        }
        return null;
    }

    public static Object[] getDefaultValue(Class<?>[] paramArray) {
        if (paramArray == null) {
            return null;
        }
        Object[] objs = new Object[paramArray.length];
        for (int i = 0; i < paramArray.length; ++i) {
            objs[i] = BeanUtils.getDefaultValue(paramArray[i]);
        }
        return objs;
    }

    public static Object invokeMethod(Object target, String methodName, Object ... objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method[] ms;
        if (target == null) {
            return null;
        }
        Class<?> targetType = target.getClass();
        Method invokeMethod = null;
        for (Method m : ms = targetType.getMethods()) {
            Class<?>[] paramTypes;
            if (!m.getName().equals(methodName) || (paramTypes = m.getParameterTypes()).length != objects.length) continue;
            boolean isFind = true;
            for (int i = 0; i < paramTypes.length; ++i) {
                Object param_object = objects[i];
                if (param_object == null || paramTypes[i].isAssignableFrom(param_object.getClass())) continue;
                isFind = false;
                break;
            }
            if (!isFind) continue;
            invokeMethod = m;
        }
        if (invokeMethod == null) {
            throw new NullPointerException(methodName + " invokeMethod is null.");
        }
        return invokeMethod.invoke(target, objects);
    }

    public static List<Field> findALLFields(Class<?> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Field> fList = new ArrayList<Field>();
        BeanUtils.findALLFields(target, fList);
        return fList;
    }

    private static void findALLFields(Class<?> target, ArrayList<Field> fList) {
        if (target == null) {
            return;
        }
        for (Field field : target.getDeclaredFields()) {
            if (fList.contains(field)) continue;
            fList.add(field);
        }
        for (Field field : target.getFields()) {
            if (fList.contains(field)) continue;
            fList.add(field);
        }
        Class<?> superType = target.getSuperclass();
        if (superType == null || superType == target) {
            return;
        }
        BeanUtils.findALLFields(superType, fList);
    }

    public static List<Method> findALLMethods(Class<?> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Method> mList = new ArrayList<Method>();
        BeanUtils.findALLMethods(target, mList);
        return mList;
    }

    private static void findALLMethods(Class<?> target, ArrayList<Method> mList) {
        if (target == null) {
            return;
        }
        for (Method method : target.getDeclaredMethods()) {
            if (mList.contains(method)) continue;
            mList.add(method);
        }
        for (Method method : target.getMethods()) {
            if (mList.contains(method)) continue;
            mList.add(method);
        }
        Class<?> superType = target.getSuperclass();
        if (superType == null || superType == target) {
            return;
        }
        BeanUtils.findALLMethods(superType, mList);
    }

    public static List<Field> getFields(Class<?> type) {
        return Arrays.asList(type.getFields());
    }

    public static List<Method> getMethods(Class<?> type) {
        return Arrays.asList(type.getMethods());
    }

    public static Field getField(String fieldName, Class<?> type) {
        if (fieldName == null || type == null) {
            return null;
        }
        for (Field f : type.getFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return f;
        }
        for (Field f : type.getDeclaredFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return f;
        }
        return null;
    }

    public static Method getMethod(Class<?> atClass, String name, Class<?>[] paramType) {
        try {
            return atClass.getMethod(name, paramType);
        }
        catch (Exception e) {
            try {
                return atClass.getDeclaredMethod(name, paramType);
            }
            catch (Exception e1) {
                return null;
            }
        }
    }

    public static List<String> getPropertysAndFields(Class<?> target) {
        List<String> mnames = BeanUtils.getPropertys(target);
        List<Field> fnames = BeanUtils.getFields(target);
        for (Field f : fnames) {
            String fName = f.getName();
            if (mnames.contains(fName)) continue;
            mnames.add(fName);
        }
        return mnames;
    }

    public static List<String> getPropertys(Class<?> target) {
        ArrayList<String> mnames = new ArrayList<String>();
        List<Method> ms = BeanUtils.getMethods(target);
        for (Method m : ms) {
            String name = m.getName();
            if (name.startsWith("get") || name.startsWith("set")) {
                name = name.substring(3);
            } else {
                if (!name.startsWith("is")) continue;
                name = name.substring(2);
            }
            if (name.equals("") || mnames.contains(name = StringUtils.firstCharToLowerCase(name))) continue;
            mnames.add(name);
        }
        return mnames;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> defineType) {
        ArrayList<PropertyDescriptor> mnames = new ArrayList<PropertyDescriptor>();
        List<String> ms = BeanUtils.getPropertys(defineType);
        for (String m : ms) {
            try {
                mnames.add(new PropertyDescriptor(m, defineType));
            }
            catch (Exception exception) {}
        }
        return mnames.toArray(new PropertyDescriptor[0]);
    }

    public static Method getReadMethod(String property, Class<?> target) {
        if (property == null || target == null) {
            return null;
        }
        String methodName_1 = "get" + StringUtils.firstCharToUpperCase(property);
        String methodName_2 = "is" + StringUtils.firstCharToUpperCase(property);
        for (Method m : target.getMethods()) {
            Class<?> t;
            if (m.getParameterTypes().length != 0) continue;
            String methodName = m.getName();
            if (methodName.equals(methodName_1)) {
                return m;
            }
            if (!methodName.equals(methodName_2) || (t = m.getReturnType()) != Boolean.class && t != Boolean.TYPE) continue;
            return m;
        }
        return null;
    }

    public static Method getWriteMethod(String property, Class<?> target) {
        if (property == null || target == null) {
            return null;
        }
        String methodName = "set" + StringUtils.firstCharToUpperCase(property);
        for (Method m : target.getMethods()) {
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != 1) continue;
            return m;
        }
        return null;
    }

    public static boolean hasProperty(String propertyName, Class<?> target) {
        if (BeanUtils.getReadMethod(propertyName, target) == null) {
            return BeanUtils.getWriteMethod(propertyName, target) != null;
        }
        return true;
    }

    public static boolean hasField(String propertyName, Class<?> target) {
        return BeanUtils.getField(propertyName, target) != null;
    }

    public static boolean hasPropertyOrField(String name, Class<?> target) {
        if (!BeanUtils.hasProperty(name, target)) {
            return BeanUtils.hasField(name, target);
        }
        return true;
    }

    public static boolean canReadProperty(String propertyName, Class<?> target) {
        Method readMethod = BeanUtils.getReadMethod(propertyName, target);
        return readMethod != null;
    }

    public static boolean canReadPropertyOrField(String propertyName, Class<?> target) {
        if (!BeanUtils.canReadProperty(propertyName, target)) {
            return BeanUtils.hasField(propertyName, target);
        }
        return true;
    }

    public static boolean canWriteProperty(String propertyName, Class<?> target) {
        Method writeMethod = BeanUtils.getWriteMethod(propertyName, target);
        return writeMethod != null;
    }

    public static boolean canWriteField(String propertyName, Class<?> target) {
        Field field = BeanUtils.getField(propertyName, target);
        return field != null && !Modifier.isFinal(field.getModifiers());
    }

    public static boolean canWritePropertyOrField(String propertyName, Class<?> target) {
        if (!BeanUtils.canWriteProperty(propertyName, target)) {
            return BeanUtils.canWriteField(propertyName, target);
        }
        return true;
    }

    public static boolean writeProperty(Object object, String attName, Object value) {
        if (object == null || attName == null) {
            return false;
        }
        Class<?> defineType = object.getClass();
        Method writeMethod = BeanUtils.getWriteMethod(attName, defineType);
        if (writeMethod == null) {
            return false;
        }
        Class<?> toType = writeMethod.getParameterTypes()[0];
        Object attValueObject = ConverterUtils.convert(toType, value);
        try {
            writeMethod.invoke(object, attValueObject);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean writeField(Object object, String fieldName, Object value) {
        if (object == null || fieldName == null) {
            return false;
        }
        Class<?> defineType = object.getClass();
        Field writeField = BeanUtils.getField(fieldName, defineType);
        if (writeField == null) {
            return false;
        }
        Class<?> toType = writeField.getType();
        Object attValueObject = ConverterUtils.convert(toType, value);
        try {
            writeField.setAccessible(true);
            writeField.set(object, attValueObject);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean writePropertyOrField(Object object, String attName, Object value) {
        Class<?> defineType = object.getClass();
        if (BeanUtils.canWriteProperty(attName, defineType)) {
            return BeanUtils.writeProperty(object, attName, value);
        }
        if (BeanUtils.hasField(attName, defineType)) {
            return BeanUtils.writeField(object, attName, value);
        }
        return false;
    }

    public static Object readProperty(Object object, String attName) {
        if (object == null || attName == null) {
            return false;
        }
        Class<?> defineType = object.getClass();
        Method readMethod = BeanUtils.getReadMethod(attName, defineType);
        if (readMethod == null) {
            return null;
        }
        try {
            return readMethod.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object readField(Object object, String fieldName) {
        if (object == null || fieldName == null) {
            return null;
        }
        Class<?> defineType = object.getClass();
        Field readField = BeanUtils.getField(fieldName, defineType);
        if (readField == null) {
            return null;
        }
        try {
            readField.setAccessible(true);
            return readField.get(object);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object readPropertyOrField(Object object, String attName) {
        Class<?> defineType = object.getClass();
        if (BeanUtils.canReadProperty(attName, defineType)) {
            return BeanUtils.readProperty(object, attName);
        }
        if (BeanUtils.hasField(attName, defineType)) {
            return BeanUtils.readField(object, attName);
        }
        return null;
    }

    public static Class<?> getPropertyType(Class<?> defineType, String attName) {
        try {
            PropertyDescriptor pd = new PropertyDescriptor(attName, defineType);
            return pd.getPropertyType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> getFieldType(Class<?> defineType, String attName) {
        Field readField = BeanUtils.getField(attName, defineType);
        if (readField != null) {
            return readField.getType();
        }
        return null;
    }

    public static Class<?> getPropertyOrFieldType(Class<?> defineType, String attName) {
        Class<?> propType = null;
        propType = BeanUtils.getPropertyType(defineType, attName);
        if (propType != null) {
            return propType;
        }
        propType = BeanUtils.getFieldType(defineType, attName);
        return propType;
    }

    public static void copyProperties(Object dest, Object orig) {
        if (dest == null) {
            throw new IllegalArgumentException("dest is null");
        }
        if (orig == null) {
            throw new IllegalArgumentException("orig is null");
        }
        List<Object> propNames = new ArrayList();
        if (orig instanceof Map) {
            for (Object object : ((Map)orig).keySet()) {
                propNames.add(object.toString());
            }
        } else {
            propNames = BeanUtils.getPropertys(orig.getClass());
        }
        for (String string : propNames) {
            BeanUtils.copyProperty(dest, orig, string);
        }
    }

    public static void copyProperty(Object dest, Object orig, String propertyName) {
        if (dest == null) {
            throw new IllegalArgumentException("dest is null");
        }
        if (orig == null) {
            throw new IllegalArgumentException("orig is null");
        }
        if (StringUtils.isBlank(propertyName)) {
            throw new IllegalArgumentException("propertyName is null");
        }
        if (!(orig instanceof Map) && !BeanUtils.canReadPropertyOrField(propertyName, orig.getClass())) {
            return;
        }
        if (!(dest instanceof Map) && !BeanUtils.canWritePropertyOrField(propertyName, dest.getClass())) {
            return;
        }
        Object val = null;
        val = !(orig instanceof Map) ? BeanUtils.readPropertyOrField(orig, propertyName) : ((Map)orig).get(propertyName);
        if (!(dest instanceof Map)) {
            BeanUtils.writePropertyOrField(dest, propertyName, val);
        } else {
            ((Map)dest).put(propertyName, val);
        }
    }
}

