/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils.json;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Logger;
import net.hasor.utils.json.JSON;
import net.hasor.utils.json.Loader;

public class JSONEnumConvertor
implements JSON.Convertor {
    protected static final Logger logger = Logger.getLogger(JSONEnumConvertor.class.getName());
    private boolean _fromJSON;
    private Method _valueOf;

    public JSONEnumConvertor() {
        this(false);
    }

    public JSONEnumConvertor(boolean fromJSON) {
        try {
            Class e = Loader.loadClass(this.getClass(), "java.lang.Enum");
            this._valueOf = e.getMethod("valueOf", Class.class, String.class);
        }
        catch (Exception e) {
            throw new RuntimeException("!Enums", e);
        }
        this._fromJSON = fromJSON;
    }

    @Override
    public Object fromJSON(Map map) {
        if (!this._fromJSON) {
            throw new UnsupportedOperationException();
        }
        try {
            Class c = Loader.loadClass(this.getClass(), (String)map.get("class"));
            return this._valueOf.invoke(null, c, map.get("value"));
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
            return null;
        }
    }

    @Override
    public void toJSON(Object obj, JSON.Output out) {
        if (this._fromJSON) {
            out.addClass(obj.getClass());
            out.add("value", obj.toString());
        } else {
            out.add(obj.toString());
        }
    }
}

