/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils.ref;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.hasor.utils.BeanUtils;
import net.hasor.utils.ref.AbstractMapEntry;
import net.hasor.utils.ref.Transformer;

public class BeanMap
extends AbstractMap<String, Object>
implements Cloneable {
    private transient Object bean;
    private transient Map<String, Method> readMethods = new LinkedHashMap<String, Method>();
    private transient Map<String, Method> writeMethods = new LinkedHashMap<String, Method>();
    private transient Map<String, Class<?>> types = new LinkedHashMap();
    public static final Object[] NULL_ARGUMENTS = new Object[0];
    private static final Map<Class<?>, Transformer> typeTransformers = Collections.unmodifiableMap(BeanMap.createTypeTransformers());

    private static Map<Class<?>, Transformer> createTypeTransformers() {
        HashMap defaultTransformers = new HashMap();
        defaultTransformers.put(Boolean.TYPE, input -> Boolean.valueOf(input.toString()));
        defaultTransformers.put(Character.TYPE, input -> Character.valueOf(input.toString().charAt(0)));
        defaultTransformers.put(Byte.TYPE, input -> Byte.valueOf(input.toString()));
        defaultTransformers.put(Short.TYPE, input -> Short.valueOf(input.toString()));
        defaultTransformers.put(Integer.TYPE, input -> Integer.valueOf(input.toString()));
        defaultTransformers.put(Long.TYPE, input -> Long.valueOf(input.toString()));
        defaultTransformers.put(Float.TYPE, input -> Float.valueOf(input.toString()));
        defaultTransformers.put(Double.TYPE, input -> Double.valueOf(input.toString()));
        return defaultTransformers;
    }

    public BeanMap() {
    }

    public BeanMap(Object bean) {
        this.bean = bean;
        this.initialise();
    }

    @Override
    public String toString() {
        return "BeanMap<" + this.bean + ">";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BeanMap newMap = (BeanMap)super.clone();
        if (this.bean == null) {
            return newMap;
        }
        Object newBean = null;
        Class<?> beanClass = this.bean.getClass();
        try {
            newBean = beanClass.newInstance();
        }
        catch (Exception e) {
            throw new CloneNotSupportedException("Unable to instantiate the underlying bean \"" + beanClass.getName() + "\": " + e);
        }
        try {
            newMap.setBean(newBean);
        }
        catch (Exception exception) {
            throw new CloneNotSupportedException("Unable to set bean in the cloned bean map: " + exception);
        }
        try {
            for (String key : this.readMethods.keySet()) {
                if (this.getWriteMethod(key) == null) continue;
                newMap.put(key, this.get(key));
            }
        }
        catch (Exception exception) {
            throw new CloneNotSupportedException("Unable to copy bean values to cloned bean map: " + exception);
        }
        return newMap;
    }

    public void putAllWriteable(BeanMap map) {
        for (String key : map.readMethods.keySet()) {
            if (this.getWriteMethod(key) == null) continue;
            this.put(key, map.get(key));
        }
    }

    @Override
    public void clear() {
        if (this.bean == null) {
            return;
        }
        Class<?> beanClass = null;
        try {
            beanClass = this.bean.getClass();
            this.bean = beanClass.newInstance();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Could not create new instance of class: " + beanClass);
        }
    }

    @Override
    public boolean containsKey(Object name) {
        Method method = this.getReadMethod(name);
        return method != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    @Override
    public Object get(Object name) {
        Method method;
        if (this.bean != null && (method = this.getReadMethod(name)) != null) {
            try {
                return method.invoke(this.bean, NULL_ARGUMENTS);
            }
            catch (IllegalAccessException e) {
                this.logWarn(e);
            }
            catch (IllegalArgumentException e) {
                this.logWarn(e);
            }
            catch (InvocationTargetException e) {
                this.logWarn(e);
            }
            catch (NullPointerException e) {
                this.logWarn(e);
            }
        }
        return null;
    }

    @Override
    public Object put(String name, Object value) throws IllegalArgumentException, ClassCastException {
        if (this.bean != null) {
            Object oldValue = this.get(name);
            Method method = this.getWriteMethod(name);
            if (method == null) {
                throw new IllegalArgumentException("The bean of type: " + this.bean.getClass().getName() + " has no property called: " + name);
            }
            try {
                Object[] arguments = this.createWriteMethodArguments(method, value);
                method.invoke(this.bean, arguments);
                Object newValue = this.get(name);
                this.firePropertyChange(name, oldValue, newValue);
            }
            catch (InvocationTargetException e) {
                this.logInfo(e);
                throw new IllegalArgumentException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                this.logInfo(e);
                throw new IllegalArgumentException(e.getMessage());
            }
            return oldValue;
        }
        return null;
    }

    @Override
    public int size() {
        return this.readMethods.size();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.readMethods.keySet());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return BeanMap.this.entryIterator();
            }

            @Override
            public int size() {
                return BeanMap.this.readMethods.size();
            }
        });
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> answer = new ArrayList<Object>(this.readMethods.size());
        Iterator<Object> iter = this.valueIterator();
        while (iter.hasNext()) {
            answer.add(iter.next());
        }
        return Collections.unmodifiableList(answer);
    }

    public Class<?> getType(String name) {
        return this.types.get(name);
    }

    public Iterator<String> keyIterator() {
        return this.readMethods.keySet().iterator();
    }

    public Iterator<Object> valueIterator() {
        final Iterator<String> iter = this.keyIterator();
        return new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Object next() {
                Object key = iter.next();
                return BeanMap.this.get(key);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported for BeanMap");
            }
        };
    }

    public Iterator<Map.Entry<String, Object>> entryIterator() {
        final Iterator<String> iter = this.keyIterator();
        return new Iterator<Map.Entry<String, Object>>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Map.Entry<String, Object> next() {
                String key = (String)iter.next();
                Object value = BeanMap.this.get(key);
                return new Entry(BeanMap.this, key, value);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported for BeanMap");
            }
        };
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object newBean) {
        this.bean = newBean;
        this.reinitialise();
    }

    public Method getReadMethod(String name) {
        return this.readMethods.get(name);
    }

    public Method getWriteMethod(String name) {
        return this.writeMethods.get(name);
    }

    protected Method getReadMethod(Object name) {
        return this.readMethods.get(name);
    }

    protected Method getWriteMethod(Object name) {
        return this.writeMethods.get(name);
    }

    protected void reinitialise() {
        this.readMethods.clear();
        this.writeMethods.clear();
        this.types.clear();
        this.initialise();
    }

    private void initialise() {
        if (this.getBean() == null) {
            return;
        }
        Class<?> beanClass = this.getBean().getClass();
        try {
            LinkedHashMap<String, PropertyDescriptor> pd = new LinkedHashMap<String, PropertyDescriptor>();
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            BeanUtils.getPropertys(beanClass).forEach((? super T s) -> {
                PropertyDescriptor cfr_ignored_0 = pd.put((String)s, (PropertyDescriptor)null);
            });
            if (propertyDescriptors != null) {
                for (int i = 0; i < propertyDescriptors.length; ++i) {
                    PropertyDescriptor propertyDescriptor2 = propertyDescriptors[i];
                    pd.put(propertyDescriptor2.getName(), propertyDescriptor2);
                }
            }
            pd.forEach((name, propertyDescriptor) -> {
                if (propertyDescriptor == null) {
                    return;
                }
                Method readMethod = propertyDescriptor.getReadMethod();
                Method writeMethod = propertyDescriptor.getWriteMethod();
                Class<?> aType = propertyDescriptor.getPropertyType();
                if (readMethod != null) {
                    this.readMethods.put((String)name, readMethod);
                }
                if (writeMethod != null) {
                    this.writeMethods.put((String)name, writeMethod);
                }
                this.types.put((String)name, aType);
            });
        }
        catch (IntrospectionException e) {
            this.logWarn(e);
        }
    }

    protected void firePropertyChange(Object key, Object oldValue, Object newValue) {
    }

    protected Object[] createWriteMethodArguments(Method method, Object value) throws IllegalAccessException, ClassCastException {
        try {
            Class<?> paramType;
            Class<?>[] types;
            if (value != null && (types = method.getParameterTypes()) != null && types.length > 0 && !(paramType = types[0]).isAssignableFrom(value.getClass())) {
                value = this.convertType(paramType, value);
            }
            Object[] answer = new Object[]{value};
            return answer;
        }
        catch (InvocationTargetException e) {
            this.logInfo(e);
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (InstantiationException e) {
            this.logInfo(e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    protected Object convertType(Class<?> newType, Object value) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[] types = new Class[]{value.getClass()};
        try {
            Constructor<?> constructor = newType.getConstructor(types);
            Object[] arguments = new Object[]{value};
            return constructor.newInstance(arguments);
        }
        catch (NoSuchMethodException e) {
            Transformer transformer = this.getTypeTransformer(newType);
            if (transformer != null) {
                return transformer.transform(value);
            }
            return value;
        }
    }

    protected Transformer getTypeTransformer(Class<?> aType) {
        return typeTransformers.get(aType);
    }

    protected void logInfo(Exception ex) {
        System.out.println("INFO: Exception: " + ex);
    }

    protected void logWarn(Exception ex) {
        System.out.println("WARN: Exception: " + ex);
        ex.printStackTrace();
    }

    protected static class Entry
    extends AbstractMapEntry<String, Object> {
        private BeanMap owner;

        protected Entry(BeanMap owner, String key, Object value) {
            super(key, value);
            this.owner = owner;
        }

        @Override
        public Object setValue(Object value) {
            String key = (String)this.getKey();
            Object oldValue = this.owner.get(key);
            this.owner.put(key, value);
            this.value = this.owner.get(key);
            return oldValue;
        }
    }
}

