/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils.ref;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;

public class WeakArrayList<T>
extends AbstractList<T> {
    private static final Object NULL_VALUE = new Object();
    private final transient ReferenceQueue<T> queue = new ReferenceQueue();
    private Object[] data;
    private int size;
    private boolean enquedElement = false;

    private static <T> T maskNull(T value) {
        return (T)(value == null ? NULL_VALUE : value);
    }

    private static <T> T unmaskNull(T value) {
        return value == NULL_VALUE ? null : (T)value;
    }

    public WeakArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.data = new Object[initialCapacity];
        this.size = 0;
    }

    public WeakArrayList() {
        this(10);
    }

    public WeakArrayList(Collection<? extends T> c) {
        this.data = new Object[c.size()];
        this.size = this.data.length;
        int i = 0;
        for (T t : c) {
            this.data[i] = this.createRef(t);
            ++i;
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.size; ++i) {
            Reference ref = (Reference)this.data[i];
            Object obj = this.data[i] == null ? null : (Object)ref.get();
            buffer.append('{');
            buffer.append(obj == null ? null : obj.toString());
            buffer.append('}');
        }
        return buffer.toString();
    }

    private Reference<T> createRef(T obj) {
        return new WeakReference<T>(WeakArrayList.maskNull(obj), this.queue);
    }

    public void ensureCapacity(int minCapacity) {
        ++this.modCount;
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this.data;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = Arrays.copyOf(oldData, newCapacity);
        }
    }

    public void trimToSize() {
        ++this.modCount;
        int oldCapacity = this.data.length;
        if (this.size < oldCapacity) {
            this.data = Arrays.copyOf(this.data, this.size);
        }
    }

    public int expurge() {
        int j;
        while (this.queue.poll() != null) {
            this.enquedElement = true;
        }
        if (this.enquedElement) {
            j = 0;
            for (int i = 0; i < this.size; ++i) {
                Reference ref = (Reference)this.data[i];
                if (ref == null || ref.isEnqueued() || ref.get() == null) {
                    if (ref != null) {
                        ref.clear();
                    }
                    this.data[i] = null;
                    continue;
                }
                if (i != j) {
                    this.data[j] = this.data[i];
                    this.data[i] = null;
                }
                ++j;
            }
            this.enquedElement = false;
        } else {
            j = this.size;
        }
        while (this.queue.poll() != null) {
            this.enquedElement = true;
        }
        this.size = j;
        return this.size;
    }

    protected void assertRange(int index, boolean allowLast) {
        int csize = this.expurge();
        if (index < 0) {
            throw new IndexOutOfBoundsException("invalid negative value: " + Integer.toString(index));
        }
        if (allowLast && index > csize) {
            throw new IndexOutOfBoundsException("index>" + csize + ": " + Integer.toString(index));
        }
        if (!allowLast && index >= csize) {
            throw new IndexOutOfBoundsException("index>=" + csize + ": " + Integer.toString(index));
        }
    }

    @Override
    public int size() {
        return this.expurge();
    }

    @Override
    public T get(int index) {
        Object value;
        do {
            this.assertRange(index, false);
        } while ((value = ((Reference)this.data[index]).get()) == null);
        return WeakArrayList.unmaskNull(value);
    }

    @Override
    public T set(int index, T element) {
        Reference ref;
        Object oldValue;
        do {
            this.assertRange(index, false);
        } while ((oldValue = (ref = (Reference)this.data[index]).get()) == null);
        ref.clear();
        this.data[index] = this.createRef(element);
        ++this.modCount;
        return WeakArrayList.unmaskNull(oldValue);
    }

    @Override
    public void add(int index, T element) {
        this.assertRange(index, true);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = this.createRef(element);
        ++this.size;
        ++this.modCount;
    }

    @Override
    public T remove(int index) {
        Reference ref;
        Object oldValue;
        do {
            this.assertRange(index, false);
        } while ((oldValue = (ref = (Reference)this.data[index]).get()) == null);
        ref.clear();
        System.arraycopy(this.data, index + 1, this.data, index, this.size - index - 1);
        this.data[this.size - 1] = null;
        --this.size;
        ++this.modCount;
        return WeakArrayList.unmaskNull(oldValue);
    }
}

