/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.hasor.utils.StringUtils;
import net.hasor.utils.io.IOUtils;
import net.hasor.utils.resource.ResourceLoader;

public class ClassPathResourceLoader
implements ResourceLoader {
    private String packageName = null;
    private ClassLoader classLoader = null;
    private Map<String, Long> sizeCache = null;

    public ClassPathResourceLoader(String packageName) {
        this.packageName = packageName;
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public ClassPathResourceLoader(String packageName, ClassLoader classLoader) {
        this.packageName = packageName;
        this.classLoader = classLoader;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private String formatResourcePath(String resourcePath) {
        String path = this.packageName + (resourcePath.charAt(0) == '/' ? resourcePath : "/" + resourcePath);
        if ((path = path.replaceAll("/{2}", "/")).charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }

    @Override
    public InputStream getResourceAsStream(String resourcePath) {
        if (StringUtils.isBlank(resourcePath)) {
            return null;
        }
        return this.classLoader.getResourceAsStream(this.formatResourcePath(resourcePath));
    }

    public boolean canModify(String resourcePath) {
        if (StringUtils.isBlank(resourcePath)) {
            return false;
        }
        URL url = this.classLoader.getResource(this.formatResourcePath(resourcePath));
        return url != null && url.getProtocol().contains("file");
    }

    @Override
    public boolean exist(String resourcePath) {
        if (StringUtils.isBlank(resourcePath)) {
            return false;
        }
        URL url = this.classLoader.getResource(this.formatResourcePath(resourcePath));
        return url != null;
    }

    @Override
    public long getResourceSize(String resourcePath) throws IOException {
        try (InputStream inputStream = this.getResourceAsStream(resourcePath);){
            SizeOutputStream sizeOutputStream = new SizeOutputStream();
            IOUtils.copy(inputStream, (OutputStream)sizeOutputStream);
            long l = sizeOutputStream.currentSize();
            return l;
        }
    }

    @Override
    public URL getResource(String resourcePath) {
        return this.classLoader.getResource(this.formatResourcePath(resourcePath));
    }

    private static class SizeOutputStream
    extends OutputStream {
        private AtomicLong atomicLong = new AtomicLong();

        private SizeOutputStream() {
        }

        public long currentSize() {
            return this.atomicLong.get();
        }

        @Override
        public void write(int b) throws IOException {
            this.atomicLong.incrementAndGet();
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (b != null) {
                this.atomicLong.addAndGet(b.length);
            }
        }
    }
}

