/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;

public class Iterators {
    public static <T, O> Iterator<O> converIterator(final Iterator<T> oriIterator, final Converter<T, O> converter) {
        return new Iterator<O>(){

            @Override
            public void remove() {
                oriIterator.remove();
            }

            @Override
            public O next() {
                return converter.converter(oriIterator.next());
            }

            @Override
            public boolean hasNext() {
                return oriIterator.hasNext();
            }
        };
    }

    public static <T> Enumeration<T> asEnumeration(final Iterator<T> iterator) {
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public T nextElement() {
                return iterator.next();
            }
        };
    }

    public static <T> Enumeration<T> mergeEnumeration(Enumeration<T> enum1, Enumeration<T> enum2) {
        final Enumeration<T> i1 = enum1 != null ? enum1 : Iterators.asEnumeration(new ArrayList(0).iterator());
        final Enumeration<T> i2 = enum2 != null ? enum2 : Iterators.asEnumeration(new ArrayList(0).iterator());
        return new Enumeration<T>(){
            private Enumeration<T> it;
            {
                this.it = i1;
            }

            @Override
            public boolean hasMoreElements() {
                return i1.hasMoreElements() || i2.hasMoreElements();
            }

            @Override
            public T nextElement() {
                if (!this.it.hasMoreElements()) {
                    this.it = i2;
                }
                return this.it.nextElement();
            }
        };
    }

    public static <T> Iterator<T> mergeIterator(Iterator<T> iterator1, Iterator<T> iterator2) {
        final Iterator<T> i1 = iterator1 != null ? iterator1 : new ArrayList(0).iterator();
        final Iterator<T> i2 = iterator2 != null ? iterator2 : new ArrayList(0).iterator();
        return new Iterator<T>(){
            private Iterator<T> it;
            {
                this.it = i1;
            }

            @Override
            public boolean hasNext() {
                return i1.hasNext() || i2.hasNext();
            }

            @Override
            public T next() {
                if (!this.it.hasNext()) {
                    this.it = i2;
                }
                return this.it.next();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    public static interface Converter<T, O> {
        public O converter(T var1);
    }
}

