/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils.io.input;

import java.io.IOException;
import java.io.InputStream;

public class AutoCloseInputStream
extends InputStream {
    private InputStream in = null;
    private boolean close = false;

    public AutoCloseInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        if (this.close) {
            return -1;
        }
        int read = this.in.read();
        if (read == -1) {
            this.close();
        }
        return read;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.close = true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }
}

