/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils.resource.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.hasor.utils.resource.ResourceLoader;

public class ZipResourceLoader
implements ResourceLoader {
    private final File zipFile;
    private final Map<String, Long> zipEntrySet = new HashMap<String, Long>();

    public ZipResourceLoader(String zipFile) throws IOException {
        this.zipFile = new File(zipFile);
        ZipFile zipFileObj = new ZipFile(this.zipFile);
        Enumeration<? extends ZipEntry> entEnum = zipFileObj.entries();
        while (entEnum.hasMoreElements()) {
            ZipEntry zipEntry = entEnum.nextElement();
            this.zipEntrySet.put(zipEntry.getName(), zipEntry.getSize());
        }
        zipFileObj.close();
    }

    public String getZipFile() {
        return this.zipFile.getAbsolutePath();
    }

    private String formatResourcePath(String resourcePath) {
        if (resourcePath.charAt(0) == '/') {
            resourcePath = resourcePath.substring(1);
        }
        resourcePath = resourcePath.replaceAll("/{2}", "/");
        return resourcePath;
    }

    @Override
    public InputStream getResourceAsStream(String resourcePath) throws IOException {
        if (this.zipFile.isDirectory() || !this.zipFile.exists()) {
            return null;
        }
        if (!this.zipEntrySet.containsKey(resourcePath = this.formatResourcePath(resourcePath))) {
            return null;
        }
        ZipFile zipFileObj = new ZipFile(this.zipFile);
        ZipEntry entry = zipFileObj.getEntry(resourcePath);
        return new ZipEntryInputStream(zipFileObj, zipFileObj.getInputStream(entry));
    }

    @Override
    public boolean exist(String resourcePath) {
        resourcePath = this.formatResourcePath(resourcePath);
        return this.zipEntrySet.containsKey(resourcePath);
    }

    @Override
    public long getResourceSize(String resourcePath) {
        if (!this.exist(resourcePath)) {
            return -1L;
        }
        return this.zipEntrySet.get(resourcePath);
    }

    @Override
    public URL getResource(String resourcePath) throws IOException {
        if (this.zipFile.isDirectory() || !this.zipFile.exists()) {
            return null;
        }
        if (!this.zipEntrySet.containsKey(resourcePath = this.formatResourcePath(resourcePath))) {
            return null;
        }
        return new URL(this.zipFile.toURI().toURL(), "@" + resourcePath);
    }

    private static class ZipEntryInputStream
    extends InputStream {
        private InputStream targetInput;
        private ZipFile zipFileObj;

        public ZipEntryInputStream(ZipFile zipFileObj, InputStream targetInput) {
            this.zipFileObj = zipFileObj;
            this.targetInput = targetInput;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.targetInput.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.targetInput.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.targetInput.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.targetInput.available();
        }

        @Override
        public void close() throws IOException {
            this.targetInput.close();
            this.zipFileObj.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.targetInput.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.targetInput.reset();
        }

        @Override
        public boolean markSupported() {
            return this.targetInput.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this.targetInput.read();
        }
    }
}

