/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.jsqlparser.statement;

import java.util.ArrayList;
import java.util.List;
import net.hasor.dataql.fx.db.jsqlparser.expression.Expression;
import net.hasor.dataql.fx.db.jsqlparser.expression.UserVariable;
import net.hasor.dataql.fx.db.jsqlparser.statement.DeclareType;
import net.hasor.dataql.fx.db.jsqlparser.statement.Statement;
import net.hasor.dataql.fx.db.jsqlparser.statement.StatementVisitor;
import net.hasor.dataql.fx.db.jsqlparser.statement.create.table.ColDataType;
import net.hasor.dataql.fx.db.jsqlparser.statement.create.table.ColumnDefinition;

public final class DeclareStatement
implements Statement {
    private UserVariable userVariable = null;
    private DeclareType type = DeclareType.TYPE;
    private String typeName;
    private List<TypeDefExpr> typeDefExprList = new ArrayList<TypeDefExpr>();
    private List<ColumnDefinition> colDefs = new ArrayList<ColumnDefinition>();

    public void setUserVariable(UserVariable userVariable) {
        this.userVariable = userVariable;
    }

    public UserVariable getUserVariable() {
        return this.userVariable;
    }

    public DeclareType getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setDeclareType(DeclareType type) {
        this.type = type;
    }

    public void addType(ColDataType colDataType, Expression defaultExpr) {
        this.typeDefExprList.add(new TypeDefExpr(colDataType, defaultExpr));
    }

    public void addType(UserVariable userVariable, ColDataType colDataType, Expression defaultExpr) {
        this.typeDefExprList.add(new TypeDefExpr(userVariable, colDataType, defaultExpr));
    }

    public void addColumnDefinition(ColumnDefinition colDef) {
        this.colDefs.add(colDef);
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        return this.colDefs;
    }

    public List<TypeDefExpr> getTypeDefinitions() {
        return this.typeDefExprList;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("DECLARE ");
        if (this.type == DeclareType.AS) {
            b.append(this.userVariable.toString());
            b.append(" AS ").append(this.typeName);
        } else if (this.type == DeclareType.TABLE) {
            b.append(this.userVariable.toString());
            b.append(" TABLE (");
            for (int i = 0; i < this.colDefs.size(); ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(this.colDefs.get(i).toString());
            }
            b.append(")");
        } else {
            for (int i = 0; i < this.typeDefExprList.size(); ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                TypeDefExpr type = this.typeDefExprList.get(i);
                if (type.userVariable != null) {
                    b.append(type.userVariable.toString()).append(" ");
                }
                b.append(type.colDataType.toString());
                if (type.defaultExpr == null) continue;
                b.append(" = ").append(type.defaultExpr.toString());
            }
        }
        return b.toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public static class TypeDefExpr {
        public final UserVariable userVariable;
        public final ColDataType colDataType;
        public final Expression defaultExpr;

        public TypeDefExpr(ColDataType colDataType, Expression defaultExpr) {
            this(null, colDataType, defaultExpr);
        }

        public TypeDefExpr(UserVariable userVariable, ColDataType colDataType, Expression defaultExpr) {
            this.userVariable = userVariable;
            this.colDataType = colDataType;
            this.defaultExpr = defaultExpr;
        }
    }
}

