/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.jsqlparser.statement.delete;

import java.util.List;
import java.util.stream.Collectors;
import net.hasor.dataql.fx.db.jsqlparser.expression.Expression;
import net.hasor.dataql.fx.db.jsqlparser.schema.Table;
import net.hasor.dataql.fx.db.jsqlparser.statement.Statement;
import net.hasor.dataql.fx.db.jsqlparser.statement.StatementVisitor;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.Join;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.Limit;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.OrderByElement;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.PlainSelect;

public class Delete
implements Statement {
    private Table table;
    private List<Table> tables;
    private List<Join> joins;
    private Expression where;
    private Limit limit;
    private List<OrderByElement> orderByElements;

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public void setWhere(Expression expression) {
        this.where = expression;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public void setTables(List<Table> tables) {
        this.tables = tables;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> joins) {
        this.joins = joins;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("DELETE");
        if (this.tables != null && this.tables.size() > 0) {
            b.append(" ");
            b.append(this.tables.stream().map(t -> t.toString()).collect(Collectors.joining(", ")));
        }
        b.append(" FROM ");
        b.append(this.table);
        if (this.joins != null) {
            for (Join join : this.joins) {
                if (join.isSimple()) {
                    b.append(", ").append(join);
                    continue;
                }
                b.append(" ").append(join);
            }
        }
        if (this.where != null) {
            b.append(" WHERE ").append(this.where);
        }
        if (this.orderByElements != null) {
            b.append(PlainSelect.orderByToString(this.orderByElements));
        }
        if (this.limit != null) {
            b.append(this.limit);
        }
        return b.toString();
    }
}

