/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.likemybatis;

import java.util.List;
import java.util.Map;
import net.hasor.dataql.fx.db.likemybatis.SqlNode;
import net.hasor.utils.StringUtils;

public class TrimSqlNode
extends SqlNode {
    protected String prefix;
    protected String suffix;
    protected String prefixOverrides;
    protected String suffixOverrides;

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setSuffixOverrides(String suffixOverrides) {
        this.suffixOverrides = suffixOverrides;
    }

    public void setPrefixOverrides(String prefixOverrides) {
        this.prefixOverrides = prefixOverrides;
    }

    @Override
    public String getSql(Map<String, Object> paramMap, List<Object> parameters) {
        StringBuilder sqlBuffer = new StringBuilder();
        String childrenSql = this.executeChildren(paramMap, parameters);
        if (StringUtils.isNotEmpty((String)childrenSql)) {
            String[] overrideArray;
            sqlBuffer.append(StringUtils.defaultString((String)this.prefix)).append(" ");
            if (StringUtils.isNotEmpty((String)this.prefixOverrides)) {
                for (String override : overrideArray = this.prefixOverrides.split("\\|")) {
                    if (!childrenSql.trim().startsWith(override)) continue;
                    childrenSql = childrenSql.substring(childrenSql.indexOf(override) + override.length());
                    break;
                }
            }
            if (StringUtils.isNotEmpty((String)this.suffixOverrides)) {
                for (String override : overrideArray = this.suffixOverrides.split("\\|")) {
                    if (!childrenSql.trim().endsWith(override)) continue;
                    childrenSql = childrenSql.substring(0, childrenSql.lastIndexOf(override));
                    break;
                }
            }
            sqlBuffer.append(childrenSql);
            sqlBuffer.append(" ").append(StringUtils.defaultString((String)this.suffix));
        }
        return sqlBuffer.toString();
    }
}

