/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.runsql;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sql.DataSource;
import net.hasor.core.AppContext;
import net.hasor.core.BindInfo;
import net.hasor.core.spi.SpiTrigger;
import net.hasor.dataql.FragmentProcess;
import net.hasor.dataql.Hints;
import net.hasor.dataql.fx.FxHintNames;
import net.hasor.dataql.fx.basic.StringUdfSource;
import net.hasor.dataql.fx.db.FxSqlCheckChainSpi;
import net.hasor.dataql.fx.db.LookupConnectionListener;
import net.hasor.dataql.fx.db.LookupDataSourceListener;
import net.hasor.dataql.fx.db.fxquery.DefaultFxQuery;
import net.hasor.dataql.fx.db.fxquery.FxQuery;
import net.hasor.dataql.fx.db.runsql.SqlPageDialectRegister;
import net.hasor.dataql.fx.db.runsql.SqlPageObject;
import net.hasor.dataql.fx.db.runsql.dialect.SqlPageDialect;
import net.hasor.db.JdbcUtils;
import net.hasor.db.jdbc.BatchPreparedStatementSetter;
import net.hasor.db.jdbc.PreparedStatementCallback;
import net.hasor.db.jdbc.PreparedStatementSetter;
import net.hasor.db.jdbc.ResultSetExtractor;
import net.hasor.db.jdbc.RowMapper;
import net.hasor.db.jdbc.core.ArgPreparedStatementSetter;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.jdbc.extractor.RowMapperResultSetExtractor;
import net.hasor.db.jdbc.mapper.ColumnMapRowMapper;
import net.hasor.utils.StringUtils;
import net.hasor.utils.io.IOUtils;

@Singleton
public class SqlFragment
implements FragmentProcess {
    @Inject
    protected AppContext appContext;
    @Inject
    protected SpiTrigger spiTrigger;
    private DataSource defaultDataSource;
    private Map<String, DataSource> dataSourceMap;
    private static final ThreadLocal<ResultSetExtractor<List<Map<String, Object>>>> RESULT_EXTRACTOR = ThreadLocal.withInitial(() -> new RowMapperResultSetExtractor((RowMapper)new ColumnMapRowMapper()));

    @PostConstruct
    public void init() {
        this.dataSourceMap = new HashMap<String, DataSource>();
        List bindInfos = this.appContext.findBindingRegister(DataSource.class);
        for (BindInfo bindInfo : bindInfos) {
            if (StringUtils.isBlank((String)bindInfo.getBindName())) {
                if (this.defaultDataSource != null) continue;
                this.defaultDataSource = (DataSource)this.appContext.getInstance(bindInfo);
                continue;
            }
            DataSource dataSource = (DataSource)this.appContext.getInstance(bindInfo);
            if (dataSource == null) continue;
            this.dataSourceMap.put(bindInfo.getBindName(), dataSource);
        }
    }

    protected JdbcTemplate getJdbcTemplate(String sourceName) {
        Connection jdbcConnection;
        if (this.spiTrigger.hasSpi(LookupConnectionListener.class) && (jdbcConnection = (Connection)this.spiTrigger.notifySpi(LookupConnectionListener.class, (listener, lastResult) -> listener.lookUp(sourceName), null)) != null) {
            return new JdbcTemplate(jdbcConnection);
        }
        DataSource useDataSource = null;
        useDataSource = StringUtils.isBlank((String)sourceName) ? this.defaultDataSource : this.dataSourceMap.get(sourceName);
        if (useDataSource == null) {
            DataSource dataSource;
            if (this.spiTrigger.hasSpi(LookupDataSourceListener.class) && (dataSource = (DataSource)this.spiTrigger.notifySpi(LookupDataSourceListener.class, (listener, lastResult) -> listener.lookUp(sourceName), null)) != null) {
                return new JdbcTemplate(dataSource);
            }
            throw new NullPointerException("DataSource " + sourceName + " is undefined.");
        }
        return new JdbcTemplate(useDataSource);
    }

    public List<Object> batchRunFragment(Hints hint, List<Map<String, Object>> params, String fragmentString) throws Throwable {
        if (params == null || params.size() == 0) {
            return Collections.singletonList(this.runFragment(hint, Collections.emptyMap(), fragmentString));
        }
        if (params.size() == 1) {
            return Collections.singletonList(this.runFragment(hint, params.get(0), fragmentString));
        }
        FxQuery fxSql = this.analysisSQL(hint, fragmentString);
        String tempFragmentString = fxSql.buildQueryString(params.get(0));
        boolean useBatch = true;
        if (fxSql.isHavePlaceholder()) {
            useBatch = false;
        } else {
            SqlMode sqlMode = SqlFragment.evalSqlMode(tempFragmentString);
            boolean bl = useBatch = SqlMode.Insert == sqlMode || SqlMode.Update == sqlMode || SqlMode.Delete == sqlMode;
        }
        if (!useBatch) {
            ArrayList<Object> resultList = new ArrayList<Object>(params.size());
            for (Map<String, Object> paramItem : params) {
                if (this.usePage(hint)) {
                    resultList.add(this.usePageFragment(fxSql, hint, paramItem));
                    continue;
                }
                resultList.add(this.noPageFragment(fxSql, hint, paramItem));
            }
            return resultList;
        }
        List batchParam = params.stream().map(preparedParams -> fxSql.buildParameterSource(preparedParams).toArray()).collect(Collectors.toList());
        String sourceName = hint.getOrDefault(FxHintNames.FRAGMENT_SQL_DATA_SOURCE.name(), (Object)"").toString();
        return this.executeSQL(true, sourceName, tempFragmentString, batchParam.toArray(), new SqlQuery<List<Object>>(){

            @Override
            public List<Object> doQuery(String querySQL, Object[] params, JdbcTemplate useJdbcTemplate) throws SQLException {
                final PreparedStatementSetter[] parameterArrays = (PreparedStatementSetter[])Arrays.stream(params).map(o -> new ArgPreparedStatementSetter((Object[])o)).toArray(PreparedStatementSetter[]::new);
                int[] executeBatch = useJdbcTemplate.executeBatch(querySQL, new BatchPreparedStatementSetter(){

                    public void setValues(PreparedStatement ps, int i) throws SQLException {
                        parameterArrays[i].setValues(ps);
                    }

                    public int getBatchSize() {
                        return parameterArrays.length;
                    }
                });
                return Arrays.stream(executeBatch).boxed().collect(Collectors.toList());
            }
        });
    }

    public Object runFragment(Hints hint, Map<String, Object> paramMap, String fragmentString) throws Throwable {
        FxQuery fxSql = this.analysisSQL(hint, fragmentString);
        if (this.usePage(hint) && SqlFragment.evalSqlMode(fragmentString) == SqlMode.Query) {
            return this.usePageFragment(fxSql, hint, paramMap);
        }
        return this.noPageFragment(fxSql, hint, paramMap);
    }

    protected Object usePageFragment(FxQuery fxSql, Hints hints, Map<String, Object> paramMap) throws SQLException {
        String useDataSource;
        String sqlDialect = hints.getOrDefault(FxHintNames.FRAGMENT_SQL_PAGE_DIALECT.name(), (Object)"").toString();
        if (StringUtils.isBlank((String)sqlDialect) && StringUtils.isBlank((String)(sqlDialect = (String)this.getJdbcTemplate(useDataSource = hints.getOrDefault(FxHintNames.FRAGMENT_SQL_DATA_SOURCE.name(), (Object)"").toString()).execute(con -> {
            String jdbcUrl = con.getMetaData().getURL();
            String jdbcDriverName = con.getMetaData().getDriverName();
            return JdbcUtils.getDbType((String)jdbcUrl, (String)jdbcDriverName);
        })))) {
            throw new IllegalArgumentException("Query dialect missing.");
        }
        SqlPageDialect pageDialect = SqlPageDialectRegister.findOrCreate(sqlDialect, this.appContext);
        return new SqlPageObject(hints, fxSql, paramMap, pageDialect, this);
    }

    protected Object noPageFragment(FxQuery fxSql, Hints hint, Map<String, Object> paramMap) throws Throwable {
        String useSourceName = hint.getOrDefault(FxHintNames.FRAGMENT_SQL_DATA_SOURCE.name(), (Object)"").toString();
        String buildQueryString = fxSql.buildQueryString(paramMap);
        Object[] buildQueryParams = fxSql.buildParameterSource(paramMap).toArray();
        return this.executeSQL(useSourceName, buildQueryString, buildQueryParams, (queryString, queryParams, useJdbcTemplate) -> {
            PreparedStatementCallback preparedCallback = ps -> {
                ResultSet resultSet;
                ArrayList<Object> resultDataSet = new ArrayList<Object>();
                String keepType = hint.getOrDefault(FxHintNames.FRAGMENT_SQL_MULTIPLE_QUERIES.name(), (Object)"last").toString();
                new ArgPreparedStatementSetter(queryParams).setValues(ps);
                if (ps.execute()) {
                    resultSet = ps.getResultSet();
                    resultDataSet.add(this.dataExtractor(hint, resultSet));
                } else {
                    resultDataSet.add(ps.getUpdateCount());
                }
                while (ps.getMoreResults()) {
                    resultSet = ps.getResultSet();
                    if ("first".equalsIgnoreCase(keepType)) continue;
                    if ("last".equalsIgnoreCase(keepType)) {
                        resultDataSet.set(0, this.dataExtractor(hint, resultSet));
                        continue;
                    }
                    if (!"all".equalsIgnoreCase(keepType)) continue;
                    resultDataSet.add(this.dataExtractor(hint, resultSet));
                }
                if (resultDataSet.size() <= 1) {
                    return resultDataSet.get(0);
                }
                return resultDataSet;
            };
            return useJdbcTemplate.execute(queryString, preparedCallback);
        });
    }

    <T> T executeSQL(String sourceName, String sqlString, Object[] paramArrays, SqlQuery<T> sqlQuery) throws SQLException {
        return this.executeSQL(false, sourceName, sqlString, paramArrays, sqlQuery);
    }

    protected <T> T executeSQL(boolean batch, String sourceName, String sqlString, Object[] paramArrays, SqlQuery<T> sqlQuery) throws SQLException {
        if (this.spiTrigger.hasSpi(FxSqlCheckChainSpi.class)) {
            FxSqlCheckChainSpi.FxSqlInfo fxSqlInfo = new FxSqlCheckChainSpi.FxSqlInfo(batch, sourceName, sqlString, paramArrays);
            AtomicBoolean doExit = new AtomicBoolean(false);
            this.spiTrigger.chainSpi(FxSqlCheckChainSpi.class, (listener, lastResult) -> {
                if (doExit.get()) {
                    return lastResult;
                }
                int doCheck = listener.doCheck(fxSqlInfo);
                if (doCheck == 2) {
                    doExit.set(true);
                }
                return lastResult;
            }, (Object)fxSqlInfo);
            return sqlQuery.doQuery(fxSqlInfo.getQueryString(), fxSqlInfo.getQueryParams(), this.getJdbcTemplate(sourceName));
        }
        return sqlQuery.doQuery(sqlString, paramArrays, this.getJdbcTemplate(sourceName));
    }

    protected FxQuery analysisSQL(Hints hint, String fragmentString) {
        return DefaultFxQuery.analysisSQL(fragmentString);
    }

    protected Object convertResult(Hints hint, List<Map<String, Object>> mapList) {
        boolean packageOff;
        String openPackage = hint.getOrDefault(FxHintNames.FRAGMENT_SQL_OPEN_PACKAGE.name(), (Object)FxHintNames.FRAGMENT_SQL_OPEN_PACKAGE.getDefaultVal()).toString();
        String caseModule = hint.getOrDefault(FxHintNames.FRAGMENT_SQL_COLUMN_CASE.name(), (Object)FxHintNames.FRAGMENT_SQL_COLUMN_CASE.getDefaultVal()).toString();
        if (!"default".equalsIgnoreCase(caseModule)) {
            boolean toUpper = "upper".equalsIgnoreCase(caseModule);
            boolean toLower = "lower".equalsIgnoreCase(caseModule);
            boolean toHump = "hump".equalsIgnoreCase(caseModule);
            for (int i = 0; i < mapList.size(); ++i) {
                LinkedHashMap newMap = new LinkedHashMap();
                mapList.get(i).forEach((key, value) -> {
                    if (toUpper) {
                        newMap.put(key.toUpperCase(), value);
                    } else if (toLower) {
                        newMap.put(key.toLowerCase(), value);
                    } else if (toHump) {
                        newMap.put(StringUdfSource.lineToHump(key.toLowerCase()), value);
                    } else {
                        newMap.put(key, value);
                    }
                });
                mapList.set(i, newMap);
            }
        }
        if ((packageOff = "off".equalsIgnoreCase(openPackage)) || mapList != null && mapList.size() > 1) {
            return mapList;
        }
        if (mapList == null || mapList.isEmpty()) {
            if ("column".equalsIgnoreCase(openPackage)) {
                return null;
            }
            return Collections.emptyMap();
        }
        Map<String, Object> rowObject = mapList.get(0);
        if ("column".equalsIgnoreCase(openPackage)) {
            if (rowObject == null) {
                return null;
            }
            if (rowObject.size() == 1) {
                Set<Map.Entry<String, Object>> entrySet = rowObject.entrySet();
                Map.Entry<String, Object> objectEntry = entrySet.iterator().next();
                return objectEntry.getValue();
            }
        }
        return rowObject;
    }

    protected boolean usePage(Hints hint) {
        FxHintNames queryByPage = FxHintNames.FRAGMENT_SQL_QUERY_BY_PAGE;
        Object hintOrDefault = hint.getOrDefault(queryByPage.name(), (Object)queryByPage.getDefaultVal());
        return "true".equalsIgnoreCase(hintOrDefault.toString());
    }

    private static SqlMode evalSqlMode(String fragmentString) throws IOException {
        List readLines = IOUtils.readLines((Reader)new StringReader(fragmentString));
        SqlMode sqlMode = null;
        boolean multipleLines = false;
        for (String lineStr : readLines) {
            String tempLine = lineStr.trim();
            if (!multipleLines) {
                if (StringUtils.isBlank((String)tempLine) || tempLine.startsWith("--") || tempLine.startsWith("//")) continue;
                if (tempLine.startsWith("/*")) {
                    if (tempLine.contains("*/")) {
                        tempLine = tempLine.substring(tempLine.indexOf("*/") + 2).trim();
                    }
                    if (StringUtils.isBlank((String)tempLine)) continue;
                    multipleLines = true;
                }
            }
            if (multipleLines) {
                if (!tempLine.contains("*/")) continue;
                tempLine = tempLine.substring(tempLine.indexOf("*/")).trim();
                multipleLines = false;
            }
            if ((tempLine = tempLine.toLowerCase()).startsWith("insert") || tempLine.startsWith("replace")) {
                sqlMode = SqlMode.Insert;
                break;
            }
            if (tempLine.startsWith("update")) {
                sqlMode = SqlMode.Update;
                break;
            }
            if (tempLine.startsWith("delete")) {
                sqlMode = SqlMode.Delete;
                break;
            }
            if (tempLine.startsWith("exec")) {
                sqlMode = SqlMode.Procedure;
                break;
            }
            if (tempLine.startsWith("select")) {
                sqlMode = SqlMode.Query;
                break;
            }
            if (tempLine.startsWith("create")) {
                sqlMode = SqlMode.Create;
                break;
            }
            if (tempLine.startsWith("drop")) {
                sqlMode = SqlMode.Drop;
                break;
            }
            if (tempLine.startsWith("alter")) {
                sqlMode = SqlMode.Alter;
                break;
            }
            sqlMode = SqlMode.Other;
            break;
        }
        return sqlMode;
    }

    protected Object dataExtractor(Hints hint, ResultSet resultSet) throws SQLException {
        List tempData = (List)RESULT_EXTRACTOR.get().extractData(resultSet);
        return this.convertResult(hint, tempData);
    }

    public static interface SqlQuery<T> {
        public T doQuery(String var1, Object[] var2, JdbcTemplate var3) throws SQLException;
    }

    public static enum SqlMode {
        Insert,
        Update,
        Delete,
        Procedure,
        Query,
        Create,
        Drop,
        Alter,
        Other;

    }
}

