/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.encryt;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Singleton;
import net.hasor.dataql.UdfSourceAssembly;
import net.hasor.dataql.fx.encryt.DigestType;
import net.hasor.dataql.fx.encryt.HmacType;
import net.hasor.utils.ArrayUtils;

@Singleton
public class CodecUdfSource
implements UdfSourceAssembly {
    public static String encodeString(String content) {
        if (content == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(content.getBytes());
    }

    public static String encodeBytes(List<Byte> content) {
        if (content == null) {
            return null;
        }
        if (content.size() == 0) {
            return "";
        }
        byte[] bytes = ArrayUtils.toPrimitive((Byte[])content.toArray(new Byte[0]));
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static String decodeString(String content) {
        if (content == null) {
            return null;
        }
        return new String(Base64.getDecoder().decode(content));
    }

    public static byte[] decodeBytes(String content) {
        if (content == null) {
            return null;
        }
        return Base64.getDecoder().decode(content);
    }

    public static String urlEncode(String content) throws UnsupportedEncodingException {
        return CodecUdfSource.urlEncodeBy(content, "UTF-8");
    }

    public static String urlEncodeBy(String content, String enc) throws UnsupportedEncodingException {
        if (content == null) {
            return null;
        }
        return URLEncoder.encode(content, enc);
    }

    public static String urlDecode(String content) throws UnsupportedEncodingException {
        return CodecUdfSource.urlDecodeBy(content, "UTF-8");
    }

    public static String urlDecodeBy(String content, String enc) throws UnsupportedEncodingException {
        if (content == null) {
            return null;
        }
        return URLDecoder.decode(content, enc);
    }

    public static byte[] digestBytes(String digestString, List<Byte> content) throws NoSuchAlgorithmException {
        DigestType digestType = DigestType.formString(digestString);
        if (digestType == null) {
            throw new NoSuchAlgorithmException("'" + digestString + "' digestType not found.");
        }
        if (content == null) {
            return null;
        }
        MessageDigest mdTemp = MessageDigest.getInstance(digestType.getDigestDesc());
        Byte[] bytes = content.toArray(new Byte[0]);
        mdTemp.update(ArrayUtils.toPrimitive((Byte[])bytes));
        return mdTemp.digest();
    }

    public static byte[] digestString(String digestString, String content) throws NoSuchAlgorithmException {
        DigestType digestType = DigestType.formString(digestString);
        if (digestType == null) {
            throw new NoSuchAlgorithmException("'" + digestString + "' digestType not found.");
        }
        if (content == null) {
            return null;
        }
        MessageDigest mdTemp = MessageDigest.getInstance(digestType.getDigestDesc());
        mdTemp.update(content.getBytes());
        return mdTemp.digest();
    }

    public static String hmacBytes(String hmacTypeString, String signKey, List<Byte> content) throws NoSuchAlgorithmException, InvalidKeyException {
        HmacType hmacType = HmacType.formString(hmacTypeString);
        if (hmacType == null) {
            throw new NoSuchAlgorithmException("'" + hmacTypeString + "' hmacType not found.");
        }
        if (content == null) {
            return null;
        }
        Mac mac = Mac.getInstance(hmacType.getHmacType());
        mac.init(new SecretKeySpec(signKey.getBytes(), HmacType.HmacMD5.getHmacType()));
        Byte[] bytes = content.toArray(new Byte[0]);
        byte[] rawHmac = mac.doFinal(ArrayUtils.toPrimitive((Byte[])bytes));
        return Base64.getEncoder().encodeToString(rawHmac);
    }

    public static String hmacString(String hmacTypeString, String signKey, String content) throws NoSuchAlgorithmException, InvalidKeyException {
        HmacType hmacType = HmacType.formString(hmacTypeString);
        if (hmacType == null) {
            throw new NoSuchAlgorithmException("'" + hmacTypeString + "' hmacType not found.");
        }
        if (content == null) {
            return null;
        }
        Mac mac = Mac.getInstance(hmacType.getHmacType());
        mac.init(new SecretKeySpec(signKey.getBytes(), HmacType.HmacMD5.getHmacType()));
        byte[] rawHmac = mac.doFinal(content.getBytes());
        return Base64.getEncoder().encodeToString(rawHmac);
    }
}

