/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.web;

import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import javax.servlet.http.HttpSession;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.InvokerFilter;
import net.hasor.web.invoker.HttpParameters;

@Singleton
public class FxWebInterceptor
implements InvokerFilter {
    private static final ThreadLocal<Invoker> invokerThreadLocal = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doInvoke(Invoker invoker, InvokerChain chain) throws Throwable {
        try {
            invokerThreadLocal.set(invoker);
            Object object = chain.doNext(invoker);
            return object;
        }
        finally {
            invokerThreadLocal.remove();
        }
    }

    public static Invoker invoker() {
        return invokerThreadLocal.get();
    }

    public static Map<String, String> headerMap() {
        return HttpParameters.headerMap();
    }

    public static Map<String, List<String>> headerArrayMap() {
        return HttpParameters.headerArrayMap();
    }

    public static Map<String, String> cookieMap() {
        return HttpParameters.cookieMap();
    }

    public static Map<String, List<String>> cookieArrayMap() {
        return HttpParameters.cookieArrayMap();
    }

    public static HttpSession servletSession() {
        Invoker invoker = FxWebInterceptor.invoker();
        if (invoker == null) {
            return null;
        }
        return invoker.getHttpRequest().getSession();
    }
}

