/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.basic;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import net.hasor.core.Singleton;
import net.hasor.dataql.UdfSourceAssembly;
import net.hasor.utils.ArrayUtils;
import net.hasor.utils.BooleanUtils;
import net.hasor.utils.CommonCodeUtils;
import net.hasor.utils.NumberUtils;
import net.hasor.utils.StringUtils;

@Singleton
public class ConvertUdfSource
implements UdfSourceAssembly {
    public static Number toInt(Object target) {
        if (target instanceof Number) {
            return (Number)target;
        }
        if (target == null) {
            return 0;
        }
        if (target instanceof String) {
            if (StringUtils.isBlank((String)((String)target))) {
                return 0;
            }
            return NumberUtils.createNumber((String)((String)target));
        }
        return 0;
    }

    public static String toString(Object target) {
        return String.valueOf(target);
    }

    public static Boolean toBoolean(Object target) {
        if (target instanceof Boolean) {
            return (Boolean)target;
        }
        if (target instanceof String) {
            return BooleanUtils.toBooleanObject((String)((String)target));
        }
        return Boolean.FALSE;
    }

    public static String byteToHex(List<Byte> content) {
        if (content == null) {
            return null;
        }
        if (content.size() == 0) {
            return "";
        }
        Byte[] bytes = content.toArray(new Byte[0]);
        return CommonCodeUtils.HexConversion.byte2HexStr((byte[])ArrayUtils.toPrimitive((Byte[])bytes));
    }

    public static byte[] hexToByte(String content) {
        if (content == null) {
            return null;
        }
        if (content.equals("")) {
            return new byte[0];
        }
        return CommonCodeUtils.HexConversion.hexStr2Bytes((String)content);
    }

    public static String byteToString(List<Byte> content, String charset) {
        if (content == null || content.size() == 0) {
            return null;
        }
        Byte[] bytes = content.toArray(new Byte[0]);
        return new String(ArrayUtils.toPrimitive((Byte[])bytes), Charset.forName(charset));
    }

    public static byte[] stringToByte(String content, String charset) throws UnsupportedEncodingException {
        if (content == null || content.equals("")) {
            return new byte[0];
        }
        return content.getBytes(charset);
    }
}

