/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.basic;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import net.hasor.core.Singleton;
import net.hasor.dataql.UdfSourceAssembly;

@Singleton
public class DateTimeUdfSource
implements UdfSourceAssembly {
    public static long now() {
        return System.currentTimeMillis();
    }

    public static int year(long time) {
        Calendar date = Calendar.getInstance();
        date.setTime(new Date(time));
        return date.get(1);
    }

    public static int month(long time) {
        Calendar date = Calendar.getInstance();
        date.setTime(new Date(time));
        return date.get(2) + 1;
    }

    public static int day(long time) {
        return DateTimeUdfSource.dayOfMonth(time);
    }

    public static int hour(long time) {
        Calendar date = Calendar.getInstance();
        date.setTime(new Date(time));
        return date.get(10);
    }

    public static int minute(long time) {
        Calendar date = Calendar.getInstance();
        date.setTime(new Date(time));
        return date.get(12);
    }

    public static int second(long time) {
        Calendar date = Calendar.getInstance();
        date.setTime(new Date(time));
        return date.get(13);
    }

    public static int dayOfYear(long time) {
        Calendar date = Calendar.getInstance();
        date.setTime(new Date(time));
        return date.get(6);
    }

    public static int dayOfMonth(long time) {
        Calendar date = Calendar.getInstance();
        date.setTime(new Date(time));
        return date.get(5);
    }

    public static int dayOfWeek(long time) {
        Calendar date = Calendar.getInstance();
        date.setTime(new Date(time));
        return date.get(7);
    }

    public static int weekOfMonth(long time) {
        Calendar date = Calendar.getInstance();
        date.setTime(new Date(time));
        return date.get(4);
    }

    public static String format(long time, String pattern) {
        return new SimpleDateFormat(pattern).format(new Date(time));
    }

    public static long parser(String time, String pattern) throws ParseException {
        return new SimpleDateFormat(pattern).parse(time).getTime();
    }
}

