/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.basic;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hasor.core.Singleton;
import net.hasor.dataql.UdfSourceAssembly;
import net.hasor.utils.StringUtils;

@Singleton
public class StringUdfSource
implements UdfSourceAssembly {
    private static final Pattern linePattern = Pattern.compile("_(\\w)");
    private static final Pattern humpPattern = Pattern.compile("[A-Z]");

    public static boolean startsWith(String str, String prefix) {
        return StringUdfSource._startsWith(str, prefix, false);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return StringUdfSource._startsWith(str, prefix, true);
    }

    public static boolean endsWith(String str, String suffix) {
        return StringUdfSource._endsWith(str, suffix, false);
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return StringUdfSource._endsWith(str, suffix, true);
    }

    private static boolean _startsWith(String str, String prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return str.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }

    private static boolean _endsWith(String str, String suffix, boolean ignoreCase) {
        if (str == null || suffix == null) {
            return str == null && suffix == null;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return str.regionMatches(ignoreCase, strOffset, suffix, 0, suffix.length());
    }

    public static String lineToHump(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        Matcher matcher = linePattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String humpToLine(String str) {
        if (str == null) {
            return null;
        }
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String firstCharToUpperCase(String value) {
        return StringUtils.firstCharToUpperCase((String)value);
    }

    public static String firstCharToLowerCase(String value) {
        return StringUtils.firstCharToLowerCase((String)value);
    }

    public static String toUpperCase(String value) {
        return StringUtils.upperCase((String)value);
    }

    public static String toLowerCase(String value) {
        return StringUtils.lowerCase((String)value);
    }

    public static int indexOf(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return str.indexOf(searchStr);
    }

    public static int indexOfWithStart(String str, String searchStr, int startPos) {
        if (StringUtils.isEmpty((String)str)) {
            return -1;
        }
        return str.indexOf(searchStr, startPos);
    }

    public static int indexOfIgnoreCase(String str, String searchStr) {
        return StringUtils.indexOfIgnoreCase((String)str, (String)searchStr, (int)0);
    }

    public static int indexOfIgnoreCaseWithStart(String str, String searchStr, int startPos) {
        return StringUtils.indexOfIgnoreCase((String)str, (String)searchStr, (int)startPos);
    }

    public static int lastIndexOf(String str, String searchStr) {
        if (StringUtils.isEmpty((String)str)) {
            return -1;
        }
        return str.lastIndexOf(searchStr);
    }

    public static int lastIndexOfWithStart(String str, String searchChar, int startPos) {
        if (StringUtils.isEmpty((String)str)) {
            return -1;
        }
        return str.lastIndexOf(searchChar, startPos);
    }

    public static int lastIndexOfIgnoreCase(String str, String searchStr) {
        return StringUtils.lastIndexOfIgnoreCase((String)str, (String)searchStr, (int)0);
    }

    public static int lastIndexOfIgnoreCaseWithStart(String str, String searchStr, int startPos) {
        return StringUtils.lastIndexOfIgnoreCase((String)str, (String)searchStr, (int)startPos);
    }

    public static boolean contains(String str, String searchStr) {
        return StringUtils.contains((String)str, (String)searchStr);
    }

    public static boolean containsIgnoreCase(String str, String searchStr) {
        return StringUtils.containsIgnoreCase((String)str, (String)searchStr);
    }

    public static boolean containsAny(String str, List<String> searchStrArray) {
        if (StringUtils.isEmpty((String)str) || searchStrArray == null || searchStrArray.isEmpty()) {
            return false;
        }
        for (String item : searchStrArray) {
            if (!StringUdfSource.contains(str, item)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyIgnoreCase(String str, List<String> searchStrArray) {
        if (StringUtils.isEmpty((String)str) || searchStrArray == null || searchStrArray.isEmpty()) {
            return false;
        }
        for (String item : searchStrArray) {
            if (!StringUdfSource.containsIgnoreCase(str, item)) continue;
            return true;
        }
        return false;
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String sub(String str, int start, int end) {
        return StringUtils.substring((String)str, (int)start, (int)end);
    }

    public static String left(String str, int len) {
        return StringUtils.left((String)str, (int)len);
    }

    public static String right(String str, int len) {
        return StringUtils.right((String)str, (int)len);
    }

    public static String alignRight(String str, String padChar, int len) {
        if (str != null && str.length() > len) {
            return str;
        }
        char pad = padChar.length() == 0 ? (char)' ' : (char)padChar.charAt(0);
        return StringUtils.rightPad((String)str, (int)len, (char)pad);
    }

    public static String alignLeft(String str, String padChar, int len) {
        if (str != null && str.length() > len) {
            return str;
        }
        char pad = padChar.length() == 0 ? (char)' ' : (char)padChar.charAt(0);
        return StringUtils.leftPad((String)str, (int)len, (char)pad);
    }

    public static String alignCenter(String str, String padChar, int len) {
        if (str != null && str.length() > len) {
            return str;
        }
        char pad = padChar.length() == 0 ? (char)' ' : (char)padChar.charAt(0);
        return StringUtils.center((String)str, (int)len, (char)pad);
    }

    public static int compareString(String str1, String str2) {
        str1 = str1 == null ? "" : str1;
        str2 = str2 == null ? "" : str2;
        return str1.compareTo(str2);
    }

    public static int compareStringIgnoreCase(String str1, String str2) {
        str1 = str1 == null ? "" : str1;
        str2 = str2 == null ? "" : str2;
        return str1.compareToIgnoreCase(str2);
    }

    public static List<String> split(String str, String separatorChars) {
        return Arrays.asList(StringUtils.split((String)str, (String)separatorChars));
    }

    public static String join(List<Object> array, String separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.join((Object[])array.toArray(), (String)separator);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }
}

