/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.likemybatis;

import java.io.ByteArrayInputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.hasor.core.Singleton;
import net.hasor.dataql.Hints;
import net.hasor.dataql.fx.db.likemybatis.ForeachSqlNode;
import net.hasor.dataql.fx.db.likemybatis.IfSqlNode;
import net.hasor.dataql.fx.db.likemybatis.MybatisSqlQuery;
import net.hasor.dataql.fx.db.likemybatis.SetSqlNode;
import net.hasor.dataql.fx.db.likemybatis.SqlNode;
import net.hasor.dataql.fx.db.likemybatis.TextSqlNode;
import net.hasor.dataql.fx.db.likemybatis.TrimSqlNode;
import net.hasor.dataql.fx.db.likemybatis.WhereSqlNode;
import net.hasor.dataql.fx.db.runsql.SqlFragment;
import net.hasor.db.dal.fxquery.FxQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Singleton
public class MybatisFragment
extends SqlFragment {
    @Override
    public Object runFragment(Hints hint, Map<String, Object> paramMap, String fragmentString) throws Throwable {
        SqlNode sqlNode = this.parseSqlNode(fragmentString.trim());
        MybatisSqlQuery fxSql = new MybatisSqlQuery(sqlNode);
        if (this.usePage(hint)) {
            return this.usePageFragment((FxQuery)fxSql, hint, paramMap);
        }
        return this.noPageFragment((FxQuery)fxSql, hint, paramMap);
    }

    private synchronized SqlNode parseSqlNode(String fragmentString) throws Exception {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(fragmentString.getBytes()));
        Element root = document.getDocumentElement();
        String tagName = root.getTagName();
        TextSqlNode sqlNode = new TextSqlNode("");
        if ("select".equalsIgnoreCase(tagName)) {
            sqlNode.setSqlNode(SqlFragment.SqlMode.Query);
        } else if ("update".equalsIgnoreCase(tagName)) {
            sqlNode.setSqlNode(SqlFragment.SqlMode.Update);
        } else if ("insert".equalsIgnoreCase(tagName)) {
            sqlNode.setSqlNode(SqlFragment.SqlMode.Insert);
        } else if ("delete".equalsIgnoreCase(tagName)) {
            sqlNode.setSqlNode(SqlFragment.SqlMode.Delete);
        } else {
            return sqlNode;
        }
        this.parseNodeList(sqlNode, root.getChildNodes());
        return sqlNode;
    }

    private void parseNodeList(SqlNode sqlNode, NodeList nodeList) {
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            SqlNode childNode;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                sqlNode.addChildNode(new TextSqlNode(node.getNodeValue().trim()));
                continue;
            }
            if (node.getNodeType() == 8) continue;
            String nodeName = node.getNodeName();
            if ("foreach".equalsIgnoreCase(nodeName)) {
                childNode = this.parseForeachSqlNode(node);
            } else if ("if".equalsIgnoreCase(nodeName)) {
                childNode = new IfSqlNode(this.getNodeAttributeValue(node, "test"));
            } else if ("trim".equalsIgnoreCase(nodeName)) {
                childNode = this.parseTrimSqlNode(node);
            } else if ("set".equalsIgnoreCase(nodeName)) {
                childNode = this.parseSetSqlNode();
            } else if ("where".equalsIgnoreCase(nodeName)) {
                childNode = this.parseWhereSqlNode();
            } else {
                throw new UnsupportedOperationException("Unsupported tags :" + nodeName);
            }
            sqlNode.addChildNode(childNode);
            if (!node.hasChildNodes()) continue;
            this.parseNodeList(childNode, node.getChildNodes());
        }
    }

    private ForeachSqlNode parseForeachSqlNode(Node node) {
        ForeachSqlNode foreachSqlNode = new ForeachSqlNode();
        foreachSqlNode.setCollection(this.getNodeAttributeValue(node, "collection"));
        foreachSqlNode.setSeparator(this.getNodeAttributeValue(node, "separator"));
        foreachSqlNode.setClose(this.getNodeAttributeValue(node, "close"));
        foreachSqlNode.setOpen(this.getNodeAttributeValue(node, "open"));
        foreachSqlNode.setItem(this.getNodeAttributeValue(node, "item"));
        return foreachSqlNode;
    }

    private TrimSqlNode parseTrimSqlNode(Node node) {
        TrimSqlNode trimSqlNode = new TrimSqlNode();
        trimSqlNode.setPrefix(this.getNodeAttributeValue(node, "prefix"));
        trimSqlNode.setPrefixOverrides(this.getNodeAttributeValue(node, "prefixOverrides"));
        trimSqlNode.setSuffix(this.getNodeAttributeValue(node, "suffix"));
        trimSqlNode.setSuffixOverrides(this.getNodeAttributeValue(node, "suffixOverrides"));
        return trimSqlNode;
    }

    private SetSqlNode parseSetSqlNode() {
        SetSqlNode setSqlNode = new SetSqlNode();
        return setSqlNode;
    }

    private WhereSqlNode parseWhereSqlNode() {
        WhereSqlNode whereSqlNode = new WhereSqlNode();
        return whereSqlNode;
    }

    private String getNodeAttributeValue(Node node, String attributeKey) {
        Node item = node.getAttributes().getNamedItem(attributeKey);
        return item != null ? item.getNodeValue() : null;
    }
}

