/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.web;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.hasor.core.Singleton;
import net.hasor.dataql.UdfSourceAssembly;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.invoker.HttpParameters;

@Singleton
public class WebUdfSource
implements UdfSourceAssembly {
    public static Object jsonBody() {
        Invoker invoker = HttpParameters.localInvoker();
        if (invoker == null) {
            return null;
        }
        return JSON.parse((String)invoker.getJsonBodyString());
    }

    public static Map<String, String> cookieMap() {
        return HttpParameters.cookieMap();
    }

    public static Map<String, List<String>> cookieArrayMap() {
        return HttpParameters.cookieArrayMap();
    }

    public static String getCookie(String cookieName) {
        if (StringUtils.isBlank((String)cookieName)) {
            return null;
        }
        return WebUdfSource.cookieMap().get(cookieName);
    }

    public static List<String> getCookieArray(String cookieName) {
        if (StringUtils.isBlank((String)cookieName)) {
            return null;
        }
        return WebUdfSource.cookieArrayMap().get(cookieName);
    }

    public static boolean tempCookie(String cookieName, String value) {
        HttpServletResponse httpResponse = HttpParameters.localInvoker().getHttpResponse();
        Cookie cookie = new Cookie(cookieName, value);
        cookie.setMaxAge(-1);
        httpResponse.addCookie(cookie);
        return true;
    }

    public static boolean tempCookieAll(Map<String, String> cookieMap) {
        if (cookieMap != null) {
            cookieMap.forEach(WebUdfSource::tempCookie);
            return true;
        }
        return false;
    }

    public static boolean storeCookie(String cookieName, String value, int maxAge) {
        HttpServletResponse httpResponse = HttpParameters.localInvoker().getHttpResponse();
        Cookie cookie = new Cookie(cookieName, value);
        if (maxAge <= 0) {
            maxAge = -1;
        }
        cookie.setMaxAge(maxAge);
        httpResponse.addCookie(cookie);
        return true;
    }

    public static boolean storeCookieAll(Map<String, String> cookieMap, int maxAge) {
        if (cookieMap != null) {
            cookieMap.forEach((cookieName, value) -> WebUdfSource.storeCookie(cookieName, value, maxAge));
            return true;
        }
        return false;
    }

    public static boolean removeCookie(String cookieName) {
        HttpServletResponse httpResponse = HttpParameters.localInvoker().getHttpResponse();
        Cookie cookie = new Cookie(cookieName, "");
        cookie.setMaxAge(0);
        httpResponse.addCookie(cookie);
        return true;
    }

    public static Map<String, String> headerMap() {
        return HttpParameters.headerMap();
    }

    public static Map<String, List<String>> headerArrayMap() {
        return HttpParameters.headerArrayMap();
    }

    public static String getHeader(String headerName) {
        if (StringUtils.isBlank((String)headerName)) {
            return null;
        }
        return WebUdfSource.headerMap().get(headerName);
    }

    public static List<String> getHeaderArray(String headerName) {
        if (StringUtils.isBlank((String)headerName)) {
            return null;
        }
        return WebUdfSource.headerArrayMap().get(headerName);
    }

    public static boolean setHeader(String headerName, String value) {
        if (StringUtils.isBlank((String)headerName)) {
            return false;
        }
        HttpParameters.localInvoker().getHttpResponse().setHeader(headerName, value);
        return true;
    }

    public static boolean setHeaderAll(Map<String, String> headerMap) {
        if (headerMap != null) {
            HttpServletResponse httpResponse = HttpParameters.localInvoker().getHttpResponse();
            headerMap.forEach((arg_0, arg_1) -> ((HttpServletResponse)httpResponse).setHeader(arg_0, arg_1));
            return true;
        }
        return false;
    }

    public static boolean addHeader(String headerName, String value) {
        if (StringUtils.isBlank((String)headerName)) {
            return false;
        }
        HttpParameters.localInvoker().getHttpResponse().addHeader(headerName, value);
        return true;
    }

    public static boolean addHeaderAll(Map<String, String> headerMap) {
        if (headerMap != null) {
            HttpServletResponse httpResponse = HttpParameters.localInvoker().getHttpResponse();
            headerMap.forEach((arg_0, arg_1) -> ((HttpServletResponse)httpResponse).addHeader(arg_0, arg_1));
            return true;
        }
        return false;
    }

    private static HttpSession servletSession() {
        Invoker invoker = HttpParameters.localInvoker();
        if (invoker == null) {
            return null;
        }
        return invoker.getHttpRequest().getSession();
    }

    public static List<String> sessionKeys() {
        HttpSession httpSession = WebUdfSource.servletSession();
        if (httpSession == null) {
            return Collections.emptyList();
        }
        Enumeration attributeNames = httpSession.getAttributeNames();
        ArrayList<String> names = new ArrayList<String>();
        while (attributeNames.hasMoreElements()) {
            names.add((String)attributeNames.nextElement());
        }
        return names;
    }

    public static Object getSession(String key) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        HttpSession httpSession = WebUdfSource.servletSession();
        if (httpSession == null) {
            return null;
        }
        return httpSession.getAttribute(key);
    }

    public static Object setSession(String key, Object newValue) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        HttpSession httpSession = WebUdfSource.servletSession();
        if (httpSession == null) {
            httpSession = HttpParameters.localInvoker().getHttpRequest().getSession(true);
        }
        Object oldValue = httpSession.getAttribute(key);
        httpSession.setAttribute(key, newValue);
        return oldValue;
    }

    public static boolean removeSession(String key) {
        if (StringUtils.isBlank((String)key)) {
            return false;
        }
        HttpSession httpSession = WebUdfSource.servletSession();
        if (httpSession == null) {
            return false;
        }
        httpSession.removeAttribute(key);
        return true;
    }

    public static boolean cleanSession() {
        HttpSession httpSession = WebUdfSource.servletSession();
        if (httpSession == null) {
            return false;
        }
        Enumeration attributeNames = httpSession.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            httpSession.removeAttribute((String)attributeNames.nextElement());
        }
        return true;
    }

    public static boolean sessionInvalidate() {
        HttpSession httpSession = WebUdfSource.servletSession();
        if (httpSession == null) {
            return false;
        }
        httpSession.invalidate();
        return true;
    }

    public static String sessionId() {
        HttpSession httpSession = WebUdfSource.servletSession();
        if (httpSession == null) {
            return null;
        }
        return httpSession.getId();
    }

    public static long sessionLastAccessedTime() {
        HttpSession httpSession = WebUdfSource.servletSession();
        if (httpSession == null) {
            return 0L;
        }
        return httpSession.getLastAccessedTime();
    }
}

