/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.hasor.core.Provider;
import net.hasor.dataql.Finder;
import net.hasor.dataql.Hints;
import net.hasor.dataql.Udf;
import net.hasor.dataql.UdfSource;
import net.hasor.dataql.domain.DataModel;
import net.hasor.utils.BeanUtils;
import net.hasor.utils.StringUtils;
import net.hasor.utils.convert.ConverterUtils;

public interface UdfSourceAssembly
extends UdfSource {
    default public Supplier<?> getSupplier(Class<?> targetType, Finder finder) {
        return () -> this;
    }

    default public Predicate<Method> getPredicate(Class<?> targetType) {
        return method -> {
            boolean testA = method.getDeclaringClass() != Object.class;
            boolean testB = method.getDeclaringClass() != UdfSource.class;
            boolean testC = method.getDeclaringClass() != UdfSourceAssembly.class;
            return testA && testB && testC;
        };
    }

    @Override
    default public Supplier<Map<String, Udf>> getUdfResource(Finder finder) {
        Class<?> targetType = this.getClass();
        Supplier<?> supplier = this.getSupplier(targetType, finder);
        Predicate<Method> predicate = this.getPredicate(targetType);
        return Provider.of((Object)new TypeUdfMap(targetType, supplier, predicate));
    }

    public static class TypeUdfMap
    extends HashMap<String, Udf> {
        public TypeUdfMap(Class<?> utilType) {
            this(utilType, method -> true);
        }

        public TypeUdfMap(Class<?> utilType, Predicate<Method> methodTypeMatcher) {
            this(utilType, (Supplier<?>)Provider.of(utilType::newInstance).asSingle(), methodTypeMatcher);
        }

        public TypeUdfMap(Class<?> utilType, Supplier<?> provider, Predicate<Method> methodTypeMatcher) {
            List methodList = BeanUtils.getMethods(utilType);
            for (Method method : methodList) {
                this.initMethod(provider, methodTypeMatcher, method);
            }
        }

        private void initMethod(Supplier<?> provider, Predicate<Method> methodTypeMatcher, final Method method) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                return;
            }
            if (!Modifier.isStatic(modifiers) && provider == null) {
                return;
            }
            if (methodTypeMatcher != null && !methodTypeMatcher.test(method)) {
                return;
            }
            if (method.getDeclaringClass() == Object.class) {
                return;
            }
            if (this.containsKey(method.getName())) {
                return;
            }
            UdfName udfName = method.getAnnotation(UdfName.class);
            if (udfName == null && (udfName = method.getDeclaringClass().getAnnotation(UdfName.class)) == null) {
                udfName = new UdfName(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return UdfName.class;
                    }

                    @Override
                    public String value() {
                        return method.getName();
                    }
                };
            }
            if (StringUtils.isBlank((String)udfName.value())) {
                throw new NullPointerException("udfName is null -> " + method.toString());
            }
            if (Modifier.isStatic(modifiers)) {
                this.put(udfName.value(), new StaticUdf(method));
            } else {
                this.put(udfName.value(), new ObjectUdf(method, provider));
            }
        }

        private static Object doInvoke(Method targetMethod, Object target, Object[] values, Hints readOnly) throws Exception {
            Class<?>[] parameterTypes = targetMethod.getParameterTypes();
            Object[] inData = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                Object paramData;
                if (Hints.class.isAssignableFrom(parameterTypes[i])) {
                    paramData = readOnly;
                } else if (UdfParams.class.isAssignableFrom(parameterTypes[i])) {
                    paramData = () -> values;
                } else {
                    Object object = paramData = i < values.length ? values[i] : null;
                }
                if (paramData instanceof DataModel) {
                    paramData = ((DataModel)paramData).asOri();
                }
                inData[i] = ConverterUtils.convert(parameterTypes[i], (Object)paramData);
            }
            return targetMethod.invoke(target, inData);
        }

        private static class ObjectUdf
        implements Udf {
            private final Method target;
            private final Supplier<?> provider;

            public ObjectUdf(Method target, Supplier<?> provider) {
                this.target = target;
                this.target.setAccessible(true);
                this.provider = provider;
            }

            @Override
            public Object call(Hints readOnly, Object ... values) throws Throwable {
                Object targetObject = this.provider.get();
                if (targetObject == null) {
                    throw new NullPointerException("target Object is null.");
                }
                return TypeUdfMap.doInvoke(this.target, targetObject, values, readOnly);
            }
        }

        private static class StaticUdf
        implements Udf {
            private final Method target;

            public StaticUdf(Method target) {
                this.target = target;
                this.target.setAccessible(true);
            }

            @Override
            public Object call(Hints readOnly, Object ... values) throws Throwable {
                return TypeUdfMap.doInvoke(this.target, null, values, readOnly);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface UdfName {
        public String value();
    }

    @FunctionalInterface
    public static interface UdfParams {
        public Object[] allParams();
    }
}

