/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast;

public interface CodeLocation {
    public CodePosition getStartPosition();

    public CodePosition getEndPosition();

    public void setStartPosition(CodePosition var1);

    public void setEndPosition(CodePosition var1);

    public static class CodeLocationInfo
    implements CodeLocation {
        private CodePosition startPosition;
        private CodePosition endPosition;

        @Override
        public CodePosition getStartPosition() {
            return this.startPosition;
        }

        @Override
        public CodePosition getEndPosition() {
            return this.endPosition;
        }

        @Override
        public void setStartPosition(CodePosition codePosition) {
            this.startPosition = codePosition;
        }

        @Override
        public void setEndPosition(CodePosition codePosition) {
            this.endPosition = codePosition;
        }

        public String toString() {
            String starStr = this.getStartPosition().toString();
            String endStr = this.getEndPosition().toString();
            if ("unknown".equalsIgnoreCase(starStr) && "unknown".equalsIgnoreCase(endStr)) {
                return "unknown";
            }
            if ("unknown".equalsIgnoreCase(endStr)) {
                return starStr;
            }
            return starStr + "~" + endStr;
        }
    }

    public static final class CodePosition {
        private final int lineNumber;
        private final int columnNumber;

        public CodePosition(int lineNumber, int columnNumber) {
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public String toString() {
            String columnNumStr;
            if (this.lineNumber <= 0 && this.columnNumber < 0) {
                return "unknown";
            }
            String lineNumStr = this.lineNumber >= 0 ? String.valueOf(this.lineNumber) : "unknown";
            String string = columnNumStr = this.columnNumber >= 0 ? String.valueOf(this.columnNumber) : "unknown";
            if ("unknown".equalsIgnoreCase(columnNumStr)) {
                return lineNumStr;
            }
            return lineNumStr + ":" + columnNumStr;
        }
    }
}

