/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.value;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.CodeLocation;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.Inst;
import net.hasor.dataql.compiler.ast.InstVisitorContext;
import net.hasor.dataql.compiler.ast.Variable;
import net.hasor.dataql.compiler.ast.token.StringToken;

public class FragmentVariable
extends CodeLocation.CodeLocationInfo
implements Inst,
Variable {
    private final StringToken fragmentName;
    private final List<StringToken> paramList = new ArrayList<StringToken>();
    private final StringToken fragmentString;
    private final boolean batchMode;

    public FragmentVariable(StringToken fragmentName, StringToken fragmentString, boolean batchMode) {
        this.fragmentName = fragmentName;
        this.fragmentString = fragmentString;
        this.batchMode = batchMode;
    }

    public StringToken getFragmentName() {
        return this.fragmentName;
    }

    public StringToken getFragmentString() {
        return this.fragmentString;
    }

    public List<StringToken> getParamList() {
        return this.paramList;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        writer.write("@@" + this.fragmentName.getValue());
        if (this.batchMode) {
            writer.write("[]");
        }
        writer.write("(");
        for (int i = 0; i < this.paramList.size(); ++i) {
            if (i == 0) {
                writer.write(this.paramList.get(i).getValue());
                continue;
            }
            writer.write("," + this.paramList.get(i).getValue());
        }
        writer.write(") <%" + this.fragmentString.getValue() + "%>");
    }
}

