/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.value;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.CodeLocation;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.InstVisitorContext;
import net.hasor.dataql.compiler.ast.RouteVariable;
import net.hasor.dataql.compiler.ast.Variable;
import net.hasor.dataql.compiler.ast.value.EnterRouteVariable;

public class FunCallRouteVariable
extends CodeLocation.CodeLocationInfo
implements RouteVariable {
    private final RouteVariable enterRoute;
    private final List<Variable> paramList = new ArrayList<Variable>();

    public FunCallRouteVariable(RouteVariable enterRoute) {
        this.enterRoute = enterRoute;
    }

    public void addParam(Variable paramVar) {
        this.paramList.add(paramVar);
    }

    @Override
    public RouteVariable getParent() {
        return this.enterRoute;
    }

    public List<Variable> getParamList() {
        return this.paramList;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        if (this.enterRoute != null) {
            this.enterRoute.accept(astVisitor);
        }
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                for (Variable param : FunCallRouteVariable.this.paramList) {
                    param.accept(astVisitor);
                }
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        this.enterRoute.doFormat(depth, formatOption, writer);
        writer.write("(");
        for (int i = 0; i < this.paramList.size(); ++i) {
            Variable variable;
            if (i > 0) {
                writer.write(", ");
            }
            if ((variable = this.paramList.get(i)) instanceof EnterRouteVariable) {
                writer.write(((EnterRouteVariable)variable).getSpecialType().getCode());
                continue;
            }
            variable.doFormat(depth + 1, formatOption, writer);
        }
        writer.write(")");
    }
}

