/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.qil.cc;

import java.io.InputStream;
import java.util.Objects;
import net.hasor.dataql.compiler.CompilerException;
import net.hasor.dataql.compiler.ast.inst.ImportInst;
import net.hasor.dataql.compiler.ast.inst.RootBlockSet;
import net.hasor.dataql.compiler.ast.token.StringToken;
import net.hasor.dataql.compiler.qil.CompilerContext;
import net.hasor.dataql.compiler.qil.InstCompiler;
import net.hasor.dataql.compiler.qil.InstQueue;
import net.hasor.dataql.runtime.QueryHelper;
import net.hasor.utils.ExceptionUtils;

public class ImportInstCompiler
implements InstCompiler<ImportInst> {
    @Override
    public void doCompiler(ImportInst astInst, InstQueue queue, CompilerContext compilerContext) {
        StringToken asNameToken = astInst.getAsName();
        StringToken importResourceToken = astInst.getImportName();
        String importResource = importResourceToken.getValue();
        String asName = asNameToken.getValue();
        ImportInst.ImportType importType = astInst.getImportType();
        if (importType == ImportInst.ImportType.Resource) {
            int importAddress = compilerContext.findImport(importResource);
            if (importAddress < 0) {
                InstQueue newMethodInst = queue.newMethodInst();
                compilerContext.putImport(importResource, newMethodInst.getName());
                this.loadResource(importResource, newMethodInst, compilerContext.createSegregate());
                importAddress = newMethodInst.getName();
            }
            this.instLocation(queue, importResourceToken);
            queue.inst((byte)63, importAddress);
        } else if (importType == ImportInst.ImportType.ClassType) {
            this.instLocation(queue, importResourceToken);
            queue.inst((byte)64, importResource);
        } else {
            throw new CompilerException("import compiler failed -> importType undefined");
        }
        int index = compilerContext.containsWithCurrent(asName);
        if (index < 0) {
            index = compilerContext.push(asName);
        }
        this.instLocation(queue, asNameToken);
        queue.inst((byte)21, index);
    }

    private void loadResource(String importName, InstQueue queue, CompilerContext compilerContext) {
        RootBlockSet queryModel = null;
        try {
            InputStream inputStream = Objects.requireNonNull(compilerContext.findResource(importName), "import resource '" + importName + "' not found.");
            queryModel = (RootBlockSet)QueryHelper.queryParser(inputStream);
        }
        catch (Exception e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e, throwable -> new CompilerException("import compiler failed -> parser failed.", (Throwable)throwable));
        }
        compilerContext.findInstCompilerByInst(queryModel).doCompiler(queue);
    }
}

