/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime;

import java.util.concurrent.atomic.AtomicInteger;
import net.hasor.dataql.compiler.ast.CodeLocation;
import net.hasor.dataql.compiler.qil.Instruction;
import net.hasor.dataql.compiler.qil.QIL;
import net.hasor.dataql.runtime.InstFilter;
import net.hasor.dataql.runtime.InstructRuntimeException;
import net.hasor.dataql.runtime.Location;
import net.hasor.utils.StringUtils;

public class InstSequence {
    private final int address;
    private final QIL queueSet;
    private final int startPosition;
    private final int endPosition;
    private final AtomicInteger sequenceIndex;
    private int[] codeLocation;
    private boolean jumpMark = false;

    InstSequence(int address, QIL queueSet) {
        this.address = address;
        this.queueSet = queueSet;
        this.startPosition = 0;
        this.endPosition = this.queueSet.iqlSize(address);
        this.sequenceIndex = new AtomicInteger(this.startPosition);
        this.codeLocation = new int[]{-1, -1, -1, -1};
    }

    InstSequence(int address, QIL queueSet, int startPosition, int endPosition) {
        this.address = address;
        this.queueSet = queueSet;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.sequenceIndex = new AtomicInteger(this.startPosition);
        this.codeLocation = new int[]{-1, -1, -1, -1};
    }

    public int getAddress() {
        return this.address;
    }

    public int programPointer() {
        return this.sequenceIndex.get();
    }

    public void updateCodeLocation(int[] ints) {
        this.codeLocation = ints;
    }

    public Location.RuntimeLocation programLocation() {
        CodeLocation.CodeLocationInfo codeLocation = new CodeLocation.CodeLocationInfo();
        if (this.codeLocation.length == 4) {
            codeLocation.setStartPosition(new CodeLocation.CodePosition(this.codeLocation[0], this.codeLocation[1]));
            codeLocation.setEndPosition(new CodeLocation.CodePosition(this.codeLocation[2], this.codeLocation[3]));
        } else {
            codeLocation.setStartPosition(new CodeLocation.CodePosition(this.codeLocation[0], -1));
            codeLocation.setEndPosition(new CodeLocation.CodePosition(-1, -1));
        }
        return Location.atRuntime(codeLocation, this.address, this.programPointer());
    }

    public InstSequence clone() {
        return new InstSequence(this.address, this.queueSet);
    }

    public Instruction currentInst() {
        if (this.queueSet == null) {
            return null;
        }
        return this.queueSet.instOf(this.address, this.sequenceIndex.get());
    }

    public InstSequence methodSet(int address) {
        if (address < 0 || address > this.queueSet.iqlPoolSize()) {
            return null;
        }
        return new InstSequence(address, this.queueSet);
    }

    public InstSequence findSubSequence(InstFilter instFilter) {
        Instruction[] curInstSet = this.queueSet.iqlArrays(this.address);
        int startIndex = this.sequenceIndex.get();
        int endIndex = curInstSet.length - 1;
        for (int i = startIndex; i < endIndex; ++i) {
            if (!instFilter.isExit(curInstSet[i])) continue;
            endIndex = i;
            break;
        }
        return new InstSequence(this.address, this.queueSet, startIndex + 1, endIndex);
    }

    public boolean hasNext() {
        return this.sequenceIndex.get() < this.endPosition;
    }

    public boolean doNext(int nextSkip) throws InstructRuntimeException {
        if (this.jumpMark) {
            this.jumpMark = false;
            return true;
        }
        if (nextSkip < 0) {
            throw new InstructRuntimeException(this.programLocation(), "nextSkip must be > 0");
        }
        int newPosition = this.sequenceIndex.get() + nextSkip;
        if (newPosition > this.endPosition) {
            return false;
        }
        if (nextSkip > 0) {
            this.sequenceIndex.addAndGet(nextSkip);
        } else {
            this.sequenceIndex.incrementAndGet();
        }
        return true;
    }

    public int exitPosition() {
        return this.endPosition;
    }

    public void jumpTo(int position) {
        this.sequenceIndex.set(position);
        this.jumpMark = true;
    }

    public void reset() {
        this.sequenceIndex.set(this.startPosition);
    }

    public String toString() {
        StringBuilder strBuffer = new StringBuilder();
        strBuffer.append("[");
        strBuffer.append(this.address);
        strBuffer.append("]\n");
        Instruction[] instList = this.queueSet.iqlArrays(this.address);
        int length = String.valueOf(instList.length).length();
        for (int i = this.startPosition; i < this.endPosition; ++i) {
            if (i == this.sequenceIndex.get()) {
                strBuffer.append("> #");
            } else {
                strBuffer.append("  #");
            }
            strBuffer.append(StringUtils.leftPad((String)String.valueOf(i), (int)length, (char)'0'));
            strBuffer.append("  ");
            strBuffer.append(instList[i].toString());
            strBuffer.append("\n");
        }
        strBuffer.append("\n");
        return strBuffer.toString();
    }
}

