/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime.operator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.hasor.core.Provider;
import net.hasor.dataql.runtime.operator.DyadicOperatorRegistry;
import net.hasor.dataql.runtime.operator.DyadicProxyOperatorProcess;
import net.hasor.dataql.runtime.operator.OperatorMatch;
import net.hasor.dataql.runtime.operator.OperatorProcess;
import net.hasor.dataql.runtime.operator.UnaryOperatorRegistry;
import net.hasor.dataql.runtime.operator.UnaryProxyOperatorProcess;
import net.hasor.dataql.runtime.operator.ops.BinaryDOP;
import net.hasor.dataql.runtime.operator.ops.BooleanUOP;
import net.hasor.dataql.runtime.operator.ops.CompareDOP;
import net.hasor.dataql.runtime.operator.ops.NumberDOP;
import net.hasor.dataql.runtime.operator.ops.NumberUOP;
import net.hasor.dataql.runtime.operator.ops.ObjectEqDOP;
import net.hasor.dataql.runtime.operator.ops.StringJointDOP;

public class OperatorManager
implements DyadicOperatorRegistry,
UnaryOperatorRegistry {
    private final Map<String, List<OperatorMatch>> unaryProcessMap = new HashMap<String, List<OperatorMatch>>();
    private final Map<String, List<OperatorMatch>> dyadicProcessMap = new HashMap<String, List<OperatorMatch>>();
    private static Supplier<OperatorManager> operatorManager = Provider.ofc(OperatorManager::initManager).asSingle();

    @Override
    public void registryOperator(String symbolName, Class<?> opeType, OperatorProcess process) {
        List matchList = this.unaryProcessMap.computeIfAbsent(symbolName, k -> new ArrayList());
        matchList.add(0, new UnaryProxyOperatorProcess(opeType, process));
    }

    @Override
    public void registryOperator(String symbolName, Class<?> fstType, Class<?> secType, OperatorProcess process) {
        List matchList = this.dyadicProcessMap.computeIfAbsent(symbolName, k -> new ArrayList());
        matchList.add(0, new DyadicProxyOperatorProcess(fstType, secType, process));
    }

    @Override
    public OperatorProcess findUnaryProcess(String symbolName, Class<?> fstType) {
        if (fstType == null) {
            return null;
        }
        List<OperatorMatch> matchList = this.unaryProcessMap.get(symbolName);
        if (matchList == null || matchList.isEmpty()) {
            return null;
        }
        for (OperatorMatch item : matchList) {
            if (!item.testMatch(fstType)) continue;
            return item;
        }
        return null;
    }

    @Override
    public OperatorProcess findDyadicProcess(String symbolName, Class<?> fstType, Class<?> secType) {
        if (fstType == null || secType == null) {
            return null;
        }
        List<OperatorMatch> matchList = this.dyadicProcessMap.get(symbolName);
        if (matchList == null || matchList.isEmpty()) {
            return null;
        }
        for (OperatorMatch item : matchList) {
            if (!item.testMatch(fstType, secType)) continue;
            return item;
        }
        return null;
    }

    public static OperatorManager defaultManager() {
        return operatorManager.get();
    }

    private static OperatorManager initManager() {
        Class[] boolSet = new Class[]{Boolean.TYPE, Boolean.class};
        Class[] classSet = new Class[]{Boolean.TYPE, Boolean.class, Number.class};
        OperatorManager om = new OperatorManager();
        om.registryOperator("!", boolSet, (OperatorProcess)new BooleanUOP());
        om.registryOperator("-", Number.class, (OperatorProcess)new NumberUOP());
        om.registryOperator("!=", Object.class, Object.class, (OperatorProcess)new ObjectEqDOP());
        om.registryOperator("==", Object.class, Object.class, (OperatorProcess)new ObjectEqDOP());
        om.registryOperator("+", Object.class, Object.class, (OperatorProcess)new StringJointDOP());
        om.registryOperator(">>>", classSet, classSet, (OperatorProcess)new BinaryDOP());
        om.registryOperator(">>", classSet, classSet, (OperatorProcess)new BinaryDOP());
        om.registryOperator("<<", classSet, classSet, (OperatorProcess)new BinaryDOP());
        om.registryOperator("^", classSet, classSet, (OperatorProcess)new BinaryDOP());
        om.registryOperator("|", classSet, classSet, (OperatorProcess)new BinaryDOP());
        om.registryOperator("&", classSet, classSet, (OperatorProcess)new BinaryDOP());
        om.registryOperator("&&", boolSet, boolSet, (OperatorProcess)new CompareDOP());
        om.registryOperator("||", boolSet, boolSet, (OperatorProcess)new CompareDOP());
        om.registryOperator("!=", classSet, classSet, (OperatorProcess)new CompareDOP());
        om.registryOperator("==", classSet, classSet, (OperatorProcess)new CompareDOP());
        om.registryOperator("<=", Number.class, Number.class, (OperatorProcess)new CompareDOP());
        om.registryOperator("<", Number.class, Number.class, (OperatorProcess)new CompareDOP());
        om.registryOperator(">=", Number.class, Number.class, (OperatorProcess)new CompareDOP());
        om.registryOperator(">", Number.class, Number.class, (OperatorProcess)new CompareDOP());
        om.registryOperator("+", Number.class, Number.class, (OperatorProcess)new NumberDOP());
        om.registryOperator("-", Number.class, Number.class, (OperatorProcess)new NumberDOP());
        om.registryOperator("*", Number.class, Number.class, (OperatorProcess)new NumberDOP());
        om.registryOperator("/", Number.class, Number.class, (OperatorProcess)new NumberDOP());
        om.registryOperator("%", Number.class, Number.class, (OperatorProcess)new NumberDOP());
        om.registryOperator("\\", Number.class, Number.class, (OperatorProcess)new NumberDOP());
        return om;
    }
}

