/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.hasor.dataql.HintValue;
import net.hasor.dataql.runtime.operator.OperatorUtils;

public interface Hints
extends HintValue {
    public String[] getHints();

    public Object getHint(String var1);

    public void removeHint(String var1);

    default public void setHints(Hints hints) {
        if (hints != null) {
            hints.forEach((optKey, value) -> {
                if (OperatorUtils.isNumber(value)) {
                    this.setHint((String)optKey, (Number)value);
                } else if (OperatorUtils.isBoolean(value)) {
                    this.setHint((String)optKey, (Boolean)value);
                } else if (value != null) {
                    this.setHint((String)optKey, value.toString());
                }
            });
        }
    }

    public void setHint(String var1, String var2);

    public void setHint(String var1, Number var2);

    public void setHint(String var1, boolean var2);

    default public void forEach(BiConsumer<String, Object> action) {
        Objects.requireNonNull(action);
        for (String hintName : this.getHints()) {
            Object optionValue = this.getHint(hintName);
            action.accept(hintName, optionValue);
        }
    }

    default public void putIfAbsent(String hintName, Object value) {
        if (this.getHint(hintName) == null) {
            if (OperatorUtils.isNumber(value)) {
                this.setHint(hintName, (Number)value);
            } else if (OperatorUtils.isBoolean(value)) {
                this.setHint(hintName, (Boolean)value);
            } else if (value != null) {
                this.setHint(hintName, value.toString());
            }
        }
    }

    default public Object getOrDefault(String hintName, Object defaultValue) {
        Object v = null;
        v = this.getHint(hintName);
        return v != null ? v : defaultValue;
    }

    default public <V> V getOrMap(String hintName, Function<Object, V> defaultValue) {
        return defaultValue.apply(this.getHint(hintName));
    }

    default public void computeIfAbsent(String hintName, Function<String, Object> mappingFunction) {
        Object newValue;
        Objects.requireNonNull(mappingFunction);
        if (this.getHint(hintName) == null && (newValue = mappingFunction.apply(hintName)) != null) {
            if (OperatorUtils.isNumber(newValue)) {
                this.setHint(hintName, (Number)newValue);
            } else if (OperatorUtils.isBoolean(newValue)) {
                this.setHint(hintName, (Boolean)newValue);
            } else {
                this.setHint(hintName, newValue.toString());
            }
        }
    }
}

