/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.binder;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.hasor.core.AppContext;
import net.hasor.core.BindInfo;
import net.hasor.dataql.DataQL;
import net.hasor.dataql.Finder;
import net.hasor.dataql.FragmentProcess;
import net.hasor.dataql.Query;
import net.hasor.dataql.compiler.qil.QIL;
import net.hasor.dataql.parser.QueryModel;
import net.hasor.dataql.runtime.CompilerArguments;
import net.hasor.dataql.runtime.HintsSet;
import net.hasor.dataql.runtime.QueryHelper;
import net.hasor.utils.BeanUtils;
import net.hasor.utils.ResourcesUtils;
import net.hasor.utils.ref.LinkedCaseInsensitiveMap;
import org.antlr.v4.runtime.CharStream;

class InnerDataQLImpl
extends HintsSet
implements DataQL,
Finder {
    private final Map<String, Supplier<?>> compilerVarMap = new HashMap();
    private final Map<String, Supplier<?>> fragmentMap = new LinkedCaseInsensitiveMap();
    private final Map<String, Supplier<?>> importPrepareMap = new ConcurrentHashMap();
    private AppContext appContext;
    private Finder parentFinder;
    private final CompilerArguments useArguments = CompilerArguments.DEFAULT.copyAsNew();

    InnerDataQLImpl() {
    }

    public void initConfig(AppContext appContext) {
        List bindInfos;
        this.appContext = appContext;
        if (this.parentFinder == null) {
            this.parentFinder = Finder.APP_CONTEXT.apply(appContext);
        }
        if ((bindInfos = appContext.findBindingRegister(FragmentProcess.class)) != null) {
            bindInfos.forEach((? super T fragmentInfo) -> {
                Supplier fragmentProcess = appContext.getProvider(fragmentInfo);
                this.fragmentMap.put(fragmentInfo.getBindName().toLowerCase(), fragmentProcess);
                this.importPrepareMap.put(fragmentInfo.getBindType().getName(), fragmentProcess);
            });
        }
    }

    public void setFinder(Finder parentFinder) {
        this.parentFinder = parentFinder;
    }

    @Override
    public InputStream findResource(String resourceName) throws IOException {
        InputStream inputStream = null;
        ClassLoader classLoader = this.appContext.getEnvironment().getClassLoader();
        if (classLoader != null) {
            resourceName = ResourcesUtils.formatResource((String)resourceName);
            inputStream = classLoader.getResourceAsStream(resourceName);
        } else {
            inputStream = ResourcesUtils.getResourceAsStream((String)resourceName);
        }
        return inputStream;
    }

    @Override
    public Object findBean(Class<?> beanType) {
        String typeName = beanType.getName();
        if (!this.importPrepareMap.containsKey(typeName)) {
            this.importPrepareMap.put(typeName, () -> this.parentFinder.findBean(beanType));
        }
        return this.importPrepareMap.get(typeName).get();
    }

    @Override
    public FragmentProcess findFragmentProcess(String fragmentType) {
        Supplier<?> supplier = this.fragmentMap.get(fragmentType);
        if (supplier == null) {
            throw new IllegalStateException(fragmentType + " fragment undefine.");
        }
        FragmentProcess process = (FragmentProcess)supplier.get();
        if (process == null) {
            throw new IllegalStateException(fragmentType + " is null.");
        }
        return process;
    }

    @Override
    public void configOption(DataQL.ConfigOption optionKey, Object value) {
        BeanUtils.writePropertyOrField((Object)this.useArguments, (String)optionKey.getConfigName(), (Object)value);
    }

    @Override
    public Finder getFinder() {
        return this;
    }

    @Override
    public <T> DataQL addShareVar(String name, Class<? extends T> implementation) {
        this.compilerVarMap.put(name, () -> this.findBean(implementation));
        return this;
    }

    @Override
    public <T> DataQL addShareVar(String name, Supplier<T> provider) {
        this.compilerVarMap.put(name, provider);
        return this;
    }

    @Override
    public Map<String, Supplier<?>> getShareVarMap() {
        return Collections.unmodifiableMap(this.compilerVarMap);
    }

    @Override
    public <T extends FragmentProcess> DataQL addFragmentProcess(String name, BindInfo<T> bindInfo) {
        this.fragmentMap.put(name, this.appContext.getProvider(bindInfo));
        return this;
    }

    @Override
    public <T extends FragmentProcess> DataQL addFragmentProcess(String name, Class<T> implementation) {
        this.fragmentMap.put(name, () -> this.findBean(implementation));
        return this;
    }

    @Override
    public <T extends FragmentProcess> DataQL addFragmentProcess(String name, Supplier<T> provider) {
        this.fragmentMap.put(name, provider);
        return this;
    }

    @Override
    public QueryModel parserQuery(CharStream charStream) {
        return QueryHelper.queryParser(charStream);
    }

    @Override
    public QIL compilerQuery(QueryModel queryModel) throws IOException {
        CompilerArguments compilerArguments = this.useArguments.copyAsNew();
        compilerArguments.getCompilerVar().addAll(this.compilerVarMap.keySet());
        return QueryHelper.queryCompiler(queryModel, compilerArguments, this.getFinder());
    }

    @Override
    public Query createQuery(QIL compilerQIL) {
        Query query = QueryHelper.createQuery(compilerQIL, (Finder)this);
        query.putShareVar(this.compilerVarMap);
        query.setHints(this);
        return query;
    }
}

