/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.cc;

import java.util.List;
import net.hasor.dataql.compiler.QueryCompilerException;
import net.hasor.dataql.compiler.qil.CompilerContext;
import net.hasor.dataql.compiler.qil.InstCompiler;
import net.hasor.dataql.compiler.qil.InstQueue;
import net.hasor.dataql.compiler.qil.Label;
import net.hasor.dataql.parser.ast.Expression;
import net.hasor.dataql.parser.ast.inst.InstSet;
import net.hasor.dataql.parser.ast.inst.SwitchInst;

public class SwitchInstCompiler
implements InstCompiler<SwitchInst> {
    @Override
    public void doCompiler(SwitchInst astInst, InstQueue queue, CompilerContext compilerContext) {
        List<SwitchInst.SwitchExpression> testBlockSet = astInst.getTestBlockSet();
        InstSet elseBlockSet = astInst.getElseBlockSet();
        if (testBlockSet.isEmpty()) {
            throw new QueryCompilerException("if testBlockSet is empty.");
        }
        Label finalLabel = queue.labelDef();
        for (SwitchInst.SwitchExpression switchExp : testBlockSet) {
            Label lastEnterIn = queue.labelDef();
            Expression testExpression = switchExp.testExpression;
            compilerContext.findInstCompilerByInst(testExpression).doCompiler(queue);
            this.instLocation(queue, switchExp.testExpression.expressCodeLocation());
            queue.inst((byte)51, lastEnterIn);
            InstSet instBlockSet = switchExp.instBlockSet;
            compilerContext.findInstCompilerByInst(instBlockSet).doCompiler(queue);
            queue.inst((byte)52, finalLabel);
            queue.inst((byte)74, lastEnterIn);
        }
        if (elseBlockSet != null) {
            compilerContext.findInstCompilerByInst(elseBlockSet).doCompiler(queue);
            queue.inst((byte)52, finalLabel);
        }
        queue.inst((byte)74, finalLabel);
    }
}

