/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.qil;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.hasor.dataql.compiler.qil.CompilerEnvironment;
import net.hasor.dataql.compiler.qil.InstCompiler;
import net.hasor.dataql.compiler.qil.InstCompilerExecutor;
import net.hasor.dataql.parser.ast.Inst;

public class CompilerContext {
    private Map<String, Integer> loadedImport = new HashMap<String, Integer>();
    private final CompilerEnvironment compilerEnvironment;
    private final Stack<List<String>> dataStack = new Stack<List<String>>(){
        {
            this.push(new ArrayList());
        }
    };

    public CompilerContext(CompilerEnvironment compilerEnvironment) {
        this.compilerEnvironment = compilerEnvironment;
    }

    public InputStream findResource(String resourceName) throws IOException {
        return this.compilerEnvironment.findResource(resourceName);
    }

    public <T extends Inst> InstCompilerExecutor findInstCompilerByInst(T instObject) {
        Class<?> instClass = instObject.getClass();
        return this.findInstCompilerByInst(instObject, instClass);
    }

    public <T extends Inst> InstCompilerExecutor findInstCompilerByInst(T instObject, Class<T> instClass) {
        InstCompiler instCompiler = this.compilerEnvironment.findInstCompilerByType(instClass);
        return queue -> instCompiler.doCompiler(instObject, queue, this);
    }

    public int findImport(String importResource) {
        Integer integer = this.loadedImport.get(importResource);
        return integer == null ? -1 : integer;
    }

    public void putImport(String importResource, int address) {
        this.loadedImport.put(importResource, address);
    }

    public void newFrame() {
        this.dataStack.push(new ArrayList());
    }

    public void dropFrame() {
        this.dataStack.pop();
    }

    public int containsWithCurrent(String target) {
        if (this.dataStack.isEmpty()) {
            return -1;
        }
        return this.dataStack.peek().indexOf(target);
    }

    public ContainsIndex containsWithTree(String target) {
        ContainsIndex index = new ContainsIndex();
        int stackSize = this.dataStack.size();
        int idx = 0;
        for (int i = stackSize - 1; i >= 0; --i) {
            index.depth = idx++;
            List stringList = (List)this.dataStack.get(i);
            int indexOf = stringList.indexOf(target);
            if (indexOf < 0) continue;
            index.index = indexOf;
            return index;
        }
        index.depth = 0;
        return index;
    }

    public int push(String target) {
        List<String> nameStack = this.dataStack.peek();
        nameStack.add(target);
        return nameStack.indexOf(target);
    }

    public int getDepth() {
        return this.dataStack.size() - 1;
    }

    public CompilerContext createSegregate() {
        CompilerContext compilerContext = new CompilerContext(this.compilerEnvironment);
        compilerContext.loadedImport = this.loadedImport;
        return compilerContext;
    }

    public static class ContainsIndex {
        public int depth = -1;
        public int index = -1;

        public boolean isValid() {
            return this.depth >= 0 && this.index >= 0;
        }
    }
}

