/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.qil;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.hasor.dataql.Finder;
import net.hasor.dataql.compiler.cc.AssertInstCompiler;
import net.hasor.dataql.compiler.cc.AtomExprInstCompiler;
import net.hasor.dataql.compiler.cc.DyadicExprInstCompiler;
import net.hasor.dataql.compiler.cc.EnterRouteVariableInstCompiler;
import net.hasor.dataql.compiler.cc.ExitInstCompiler;
import net.hasor.dataql.compiler.cc.FragmentVariableInstCompiler;
import net.hasor.dataql.compiler.cc.FunCallRouteVariableInstCompiler;
import net.hasor.dataql.compiler.cc.HintInstCompiler;
import net.hasor.dataql.compiler.cc.ImportInstCompiler;
import net.hasor.dataql.compiler.cc.InstSetInstCompiler;
import net.hasor.dataql.compiler.cc.LambdaVariableInstCompiler;
import net.hasor.dataql.compiler.cc.ListFormatInstCompiler;
import net.hasor.dataql.compiler.cc.ListVariableInstCompiler;
import net.hasor.dataql.compiler.cc.NameRouteVariableInstCompiler;
import net.hasor.dataql.compiler.cc.ObjectFormatInstCompiler;
import net.hasor.dataql.compiler.cc.ObjectVariableInstCompiler;
import net.hasor.dataql.compiler.cc.PrimitiveVariableInstCompiler;
import net.hasor.dataql.compiler.cc.PrivilegeExprInstCompiler;
import net.hasor.dataql.compiler.cc.ReturnInstCompiler;
import net.hasor.dataql.compiler.cc.RootBlockSetInstCompiler;
import net.hasor.dataql.compiler.cc.RunInstCompiler;
import net.hasor.dataql.compiler.cc.SubscriptRouteVariableInstCompiler;
import net.hasor.dataql.compiler.cc.SwitchInstCompiler;
import net.hasor.dataql.compiler.cc.TernaryExprInstCompiler;
import net.hasor.dataql.compiler.cc.ThrowInstCompiler;
import net.hasor.dataql.compiler.cc.UnaryExprInstCompiler;
import net.hasor.dataql.compiler.cc.VarInstCompiler;
import net.hasor.dataql.compiler.qil.InstCompiler;
import net.hasor.dataql.parser.ast.Inst;
import net.hasor.dataql.parser.ast.expr.AtomExpression;
import net.hasor.dataql.parser.ast.expr.DyadicExpression;
import net.hasor.dataql.parser.ast.expr.PrivilegeExpression;
import net.hasor.dataql.parser.ast.expr.TernaryExpression;
import net.hasor.dataql.parser.ast.expr.UnaryExpression;
import net.hasor.dataql.parser.ast.fmt.ListFormat;
import net.hasor.dataql.parser.ast.fmt.ObjectFormat;
import net.hasor.dataql.parser.ast.inst.AssertInst;
import net.hasor.dataql.parser.ast.inst.ExitInst;
import net.hasor.dataql.parser.ast.inst.HintInst;
import net.hasor.dataql.parser.ast.inst.ImportInst;
import net.hasor.dataql.parser.ast.inst.InstSet;
import net.hasor.dataql.parser.ast.inst.ReturnInst;
import net.hasor.dataql.parser.ast.inst.RootBlockSet;
import net.hasor.dataql.parser.ast.inst.RunInst;
import net.hasor.dataql.parser.ast.inst.SwitchInst;
import net.hasor.dataql.parser.ast.inst.ThrowInst;
import net.hasor.dataql.parser.ast.inst.VarInst;
import net.hasor.dataql.parser.ast.value.EnterRouteVariable;
import net.hasor.dataql.parser.ast.value.FragmentVariable;
import net.hasor.dataql.parser.ast.value.FunCallRouteVariable;
import net.hasor.dataql.parser.ast.value.LambdaVariable;
import net.hasor.dataql.parser.ast.value.ListVariable;
import net.hasor.dataql.parser.ast.value.NameRouteVariable;
import net.hasor.dataql.parser.ast.value.ObjectVariable;
import net.hasor.dataql.parser.ast.value.PrimitiveVariable;
import net.hasor.dataql.parser.ast.value.SubscriptRouteVariable;

public class CompilerEnvironment
implements Finder {
    private final Finder finder;
    private static final Map<Class<?>, InstCompiler<?>> typeMappingToInstCompiler = new HashMap<Class<?>, InstCompiler<?>>(){
        {
            this.put(RootBlockSet.class, new RootBlockSetInstCompiler());
            this.put(InstSet.class, new InstSetInstCompiler());
            this.put(HintInst.class, new HintInstCompiler());
            this.put(ImportInst.class, new ImportInstCompiler());
            this.put(ExitInst.class, new ExitInstCompiler());
            this.put(ReturnInst.class, new ReturnInstCompiler());
            this.put(ThrowInst.class, new ThrowInstCompiler());
            this.put(VarInst.class, new VarInstCompiler());
            this.put(RunInst.class, new RunInstCompiler());
            this.put(AssertInst.class, new AssertInstCompiler());
            this.put(SwitchInst.class, new SwitchInstCompiler());
            this.put(AtomExpression.class, new AtomExprInstCompiler());
            this.put(UnaryExpression.class, new UnaryExprInstCompiler());
            this.put(DyadicExpression.class, new DyadicExprInstCompiler());
            this.put(TernaryExpression.class, new TernaryExprInstCompiler());
            this.put(PrivilegeExpression.class, new PrivilegeExprInstCompiler());
            this.put(PrimitiveVariable.class, new PrimitiveVariableInstCompiler());
            this.put(LambdaVariable.class, new LambdaVariableInstCompiler());
            this.put(ListVariable.class, new ListVariableInstCompiler());
            this.put(ObjectVariable.class, new ObjectVariableInstCompiler());
            this.put(ObjectFormat.class, new ObjectFormatInstCompiler());
            this.put(ListFormat.class, new ListFormatInstCompiler());
            this.put(FragmentVariable.class, new FragmentVariableInstCompiler());
            this.put(SubscriptRouteVariable.class, new SubscriptRouteVariableInstCompiler());
            this.put(NameRouteVariable.class, new NameRouteVariableInstCompiler());
            this.put(EnterRouteVariable.class, new EnterRouteVariableInstCompiler());
            this.put(FunCallRouteVariable.class, new FunCallRouteVariableInstCompiler());
        }
    };

    public CompilerEnvironment(Finder finder) {
        this.finder = Objects.requireNonNull(finder, "finder is null.");
    }

    @Override
    public InputStream findResource(String resourceName) throws IOException {
        return this.finder.findResource(resourceName);
    }

    public <T extends Inst> InstCompiler<T> findInstCompilerByType(Class<T> instType) {
        return Objects.requireNonNull(typeMappingToInstCompiler.get(instType), "not found " + instType.getName() + " InstCompiler.");
    }
}

