/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.qil;

import java.lang.reflect.Field;
import net.hasor.dataql.compiler.qil.Instruction;
import net.hasor.dataql.compiler.qil.Label;
import net.hasor.dataql.compiler.qil.Opcodes;
import net.hasor.utils.StringUtils;

public class InstructionInfo
implements Opcodes,
Instruction {
    private byte instCode = 0;
    private Object[] instParam = null;

    public InstructionInfo(byte instCode, Object[] instParam) {
        this.instCode = instCode;
        this.instParam = instParam == null ? new Object[]{} : instParam;
    }

    @Override
    public byte getInstCode() {
        return this.instCode;
    }

    @Override
    public String getString(int index) {
        return (String)this.instParam[index];
    }

    @Override
    public Boolean getBoolean(int index) {
        return (Boolean)this.instParam[index];
    }

    @Override
    public Number getNumber(int index) {
        return (Number)this.instParam[index];
    }

    @Override
    public int getInt(int index) {
        return (Integer)this.instParam[index];
    }

    @Override
    public Object[] getArrays() {
        return this.instParam;
    }

    public boolean replaceLabel() {
        for (int i = 0; i < this.instParam.length; ++i) {
            if (!(this.instParam[i] instanceof Label)) continue;
            Label label = (Label)this.instParam[i];
            if (label.getIndex() == null) {
                return false;
            }
            this.instParam[i] = label.getIndex();
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder codeName = new StringBuilder();
        try {
            Field[] fields;
            for (Field field : fields = Opcodes.class.getFields()) {
                byte aByte = field.getByte(null);
                if (aByte != this.instCode) continue;
                codeName.append(field.getName());
                break;
            }
        }
        catch (IllegalAccessException e) {
            codeName.append("error : ");
            codeName.append(e.getMessage());
            return codeName.toString();
        }
        int needSpace = 10 - codeName.length();
        if (needSpace > 0) {
            codeName.append(StringUtils.leftPad((String)"", (int)needSpace, (char)' '));
        }
        for (int i = 0; i < this.instParam.length; ++i) {
            if (i > 0) {
                codeName.append(", ");
            }
            codeName.append(this.instParam[i]);
        }
        return codeName.toString().trim();
    }
}

