/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.domain;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.hasor.dataql.Udf;
import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.domain.ListModel;
import net.hasor.dataql.domain.ObjectModel;
import net.hasor.dataql.domain.UdfModel;
import net.hasor.dataql.domain.ValueModel;
import net.hasor.dataql.runtime.operator.OperatorUtils;
import net.hasor.utils.ArrayUtils;
import net.hasor.utils.ref.BeanMap;

public class DomainHelper {
    public static ValueModel nullDomain() {
        return ValueModel.NULL;
    }

    public static ListModel newList() {
        return new ListModel();
    }

    public static ObjectModel newObject() {
        return new ObjectModel();
    }

    public static DataModel convertTo(Object object) {
        if (object instanceof DataModel) {
            return (DataModel)object;
        }
        if (object == null) {
            return ValueModel.NULL;
        }
        if (OperatorUtils.isBoolean(object)) {
            if (((Boolean)object).booleanValue()) {
                return ValueModel.TRUE;
            }
            return ValueModel.FALSE;
        }
        if (object instanceof CharSequence) {
            return new ValueModel(String.valueOf(object));
        }
        if (OperatorUtils.isNumber(object)) {
            return new ValueModel(object);
        }
        if (object instanceof Date) {
            return new ValueModel(((Date)object).getTime());
        }
        if (object instanceof UUID) {
            return new ValueModel(((UUID)object).toString());
        }
        if (object.getClass().isEnum()) {
            return new ValueModel(((Enum)object).name());
        }
        if (object instanceof Map) {
            Map mapData = (Map)object;
            Set entrySet = mapData.entrySet();
            ObjectModel objectModel = new ObjectModel();
            for (Map.Entry entry : entrySet) {
                if (!(entry instanceof Map.Entry)) continue;
                Object key = entry.getKey();
                Object val = entry.getValue();
                objectModel.put(key.toString(), DomainHelper.convertTo(val));
            }
            return objectModel;
        }
        if (object.getClass().isArray()) {
            Class<?> componentType = object.getClass().getComponentType();
            Object[] objectArrays = null;
            objectArrays = componentType.isPrimitive() ? (Boolean.TYPE == componentType ? ArrayUtils.toObject((boolean[])((boolean[])object)) : (Byte.TYPE == componentType ? ArrayUtils.toObject((byte[])((byte[])object)) : (Short.TYPE == componentType ? ArrayUtils.toObject((short[])((short[])object)) : (Integer.TYPE == componentType ? ArrayUtils.toObject((int[])((int[])object)) : (Long.TYPE == componentType ? ArrayUtils.toObject((long[])((long[])object)) : (Character.TYPE == componentType ? ArrayUtils.toObject((char[])((char[])object)) : (Float.TYPE == componentType ? ArrayUtils.toObject((float[])((float[])object)) : (Double.TYPE == componentType ? ArrayUtils.toObject((double[])((double[])object)) : (Object[])object)))))))) : (Object[])object;
            return new ListModel(Arrays.asList(objectArrays));
        }
        if (object instanceof Collection) {
            return new ListModel((Collection)object);
        }
        if (object instanceof Udf) {
            return new UdfModel((Udf)object);
        }
        BeanMap beanMap = new BeanMap(object);
        ObjectModel objectModel = new ObjectModel();
        for (String entryKey : beanMap.keySet()) {
            if ("class".equals(entryKey)) continue;
            objectModel.put(entryKey, DomainHelper.convertTo(beanMap.get((Object)entryKey)));
        }
        return objectModel;
    }
}

