/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Stack;
import net.hasor.dataql.parser.DataQLParser;
import net.hasor.dataql.parser.DataQLParserVisitor;
import net.hasor.dataql.parser.QueryParseException;
import net.hasor.dataql.parser.ast.Expression;
import net.hasor.dataql.parser.ast.RouteVariable;
import net.hasor.dataql.parser.ast.Variable;
import net.hasor.dataql.parser.ast.expr.AtomExpression;
import net.hasor.dataql.parser.ast.expr.DyadicExpression;
import net.hasor.dataql.parser.ast.expr.PrivilegeExpression;
import net.hasor.dataql.parser.ast.expr.TernaryExpression;
import net.hasor.dataql.parser.ast.expr.UnaryExpression;
import net.hasor.dataql.parser.ast.fmt.ListFormat;
import net.hasor.dataql.parser.ast.fmt.ObjectFormat;
import net.hasor.dataql.parser.ast.inst.AssertInst;
import net.hasor.dataql.parser.ast.inst.ExitInst;
import net.hasor.dataql.parser.ast.inst.HintInst;
import net.hasor.dataql.parser.ast.inst.ImportInst;
import net.hasor.dataql.parser.ast.inst.InstSet;
import net.hasor.dataql.parser.ast.inst.ReturnInst;
import net.hasor.dataql.parser.ast.inst.RootBlockSet;
import net.hasor.dataql.parser.ast.inst.RunInst;
import net.hasor.dataql.parser.ast.inst.SwitchInst;
import net.hasor.dataql.parser.ast.inst.ThrowInst;
import net.hasor.dataql.parser.ast.inst.VarInst;
import net.hasor.dataql.parser.ast.token.IntegerToken;
import net.hasor.dataql.parser.ast.token.StringToken;
import net.hasor.dataql.parser.ast.token.SymbolToken;
import net.hasor.dataql.parser.ast.value.EnterRouteVariable;
import net.hasor.dataql.parser.ast.value.FragmentVariable;
import net.hasor.dataql.parser.ast.value.FunCallRouteVariable;
import net.hasor.dataql.parser.ast.value.LambdaVariable;
import net.hasor.dataql.parser.ast.value.ListVariable;
import net.hasor.dataql.parser.ast.value.NameRouteVariable;
import net.hasor.dataql.parser.ast.value.ObjectVariable;
import net.hasor.dataql.parser.ast.value.PrimitiveVariable;
import net.hasor.dataql.parser.ast.value.SubscriptRouteVariable;
import net.hasor.dataql.parser.location.BlockLocation;
import net.hasor.dataql.parser.location.CodeLocation;
import net.hasor.dataql.parser.location.Location;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.AbstractParseTreeVisitor;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class DefaultDataQLVisitor<T>
extends AbstractParseTreeVisitor<T>
implements DataQLParserVisitor<T> {
    private final Stack<Object> instStack = new Stack();

    public <T extends Location> T code(T location, TerminalNode context) {
        Token symbol = context.getSymbol();
        location.setStartPosition(new CodeLocation(symbol.getLine(), symbol.getCharPositionInLine()));
        location.setEndPosition(new CodeLocation(symbol.getLine(), symbol.getCharPositionInLine() + symbol.getText().length()));
        return location;
    }

    public <T extends Location> T code(T location, ParserRuleContext context) {
        Token startToken = context.start;
        Token endToken = context.stop;
        int endTokenLength = endToken.getText().length();
        location.setStartPosition(new CodeLocation(startToken.getLine(), startToken.getCharPositionInLine()));
        location.setEndPosition(new CodeLocation(endToken.getLine(), endToken.getCharPositionInLine() + endTokenLength));
        return location;
    }

    private <T extends Location, V extends Location> T code(T location, V other) {
        location.setStartPosition(other.getStartPosition());
        location.setEndPosition(other.getEndPosition());
        return location;
    }

    private <T extends Location, V extends Location> T code(T location, List<TerminalNode> otherList) {
        Token firstTerm = otherList.get(0).getSymbol();
        Token lastTerm = otherList.get(otherList.size() - 1).getSymbol();
        location.setStartPosition(new CodeLocation(firstTerm.getLine(), firstTerm.getCharPositionInLine()));
        location.setEndPosition(new CodeLocation(lastTerm.getLine(), lastTerm.getCharPositionInLine() + lastTerm.getText().length()));
        return location;
    }

    private <T extends Location> T code(T location, Token token) {
        int endTokenLength = token.getText().length();
        location.setStartPosition(new CodeLocation(token.getLine(), token.getCharPositionInLine()));
        location.setEndPosition(new CodeLocation(token.getLine(), token.getCharPositionInLine() + endTokenLength));
        return location;
    }

    private <T extends Location, V extends CodeLocation> T code(T location, V startPos, V endPos) {
        location.setStartPosition(startPos);
        location.setEndPosition(endPos);
        return location;
    }

    @Override
    public T visitRootInstSet(DataQLParser.RootInstSetContext ctx) {
        this.instStack.push(this.code((T)new RootBlockSet(), (Location)((Object)ctx)));
        List<DataQLParser.HintInstContext> optionList = ctx.hintInst();
        List<DataQLParser.ImportInstContext> importList = ctx.importInst();
        List<DataQLParser.BlockSetContext> blockSetList = ctx.blockSet();
        if (optionList != null) {
            for (DataQLParser.HintInstContext hintInstContext : optionList) {
                hintInstContext.accept(this);
            }
        }
        if (importList != null) {
            for (DataQLParser.ImportInstContext importInstContext : importList) {
                importInstContext.accept(this);
            }
        }
        if (blockSetList != null) {
            for (DataQLParser.BlockSetContext blockSetContext : blockSetList) {
                blockSetContext.accept(this);
                InstSet instSet = (InstSet)this.instStack.pop();
                RootBlockSet rootBlockSet = (RootBlockSet)this.instStack.peek();
                if (instSet.isMultipleInst()) {
                    rootBlockSet.add(instSet);
                    continue;
                }
                rootBlockSet.addInstSet(instSet);
            }
        }
        return (T)this.instStack.pop();
    }

    @Override
    public T visitHintInst(DataQLParser.HintInstContext ctx) {
        TerminalNode identifier = ctx.IDENTIFIER();
        StringToken stringToken = this.code((T)new StringToken(this.fixIdentifier(identifier)), (Location)identifier);
        this.instStack.push(stringToken);
        this.visitChildren((RuleNode)ctx);
        PrimitiveVariable optValue = (PrimitiveVariable)this.instStack.pop();
        StringToken optKey = (StringToken)this.instStack.pop();
        HintInst hintInst = this.code((T)new HintInst(optKey, optValue), (Location)((Object)ctx));
        ((InstSet)this.instStack.peek()).addOptionInst(hintInst);
        return null;
    }

    @Override
    public T visitImportInst(DataQLParser.ImportInstContext ctx) {
        this.visitChildren((RuleNode)ctx);
        TerminalNode importResourceTerm = ctx.STRING();
        TerminalNode asNameTerm = ctx.IDENTIFIER();
        StringToken importResourceToken = this.code((T)new StringToken(this.fixString(importResourceTerm)), (Location)importResourceTerm);
        StringToken asNameToken = this.code((T)new StringToken(this.fixIdentifier(asNameTerm)), (Location)asNameTerm);
        ImportInst.ImportType importType = ImportInst.ImportType.ClassType;
        TerminalNode rouNode = ctx.ROU();
        if (rouNode != null) {
            if ("@".equals(rouNode.getText())) {
                importType = ImportInst.ImportType.Resource;
            } else {
                throw this.newParseException(rouNode.getSymbol(), "parser failed -> visitImportInst.");
            }
        }
        ImportInst importInst = this.code((T)new ImportInst(importType, importResourceToken, asNameToken), (Location)((Object)ctx));
        ((RootBlockSet)this.instStack.peek()).addImportInst(importInst);
        return null;
    }

    @Override
    public T visitMultipleInst(DataQLParser.MultipleInstContext ctx) {
        this.instStack.push(this.code((T)new InstSet(true), (Location)((Object)ctx)));
        this.visitChildren((RuleNode)ctx);
        return null;
    }

    @Override
    public T visitSingleInst(DataQLParser.SingleInstContext ctx) {
        this.instStack.push(this.code((T)new InstSet(false), (Location)((Object)ctx)));
        this.visitChildren((RuleNode)ctx);
        return null;
    }

    @Override
    public T visitVarInst(DataQLParser.VarInstContext ctx) {
        this.visitChildren((RuleNode)ctx);
        TerminalNode identifier = ctx.IDENTIFIER();
        StringToken stringToken = this.code((T)new StringToken(this.fixIdentifier(identifier)), (Location)identifier);
        VarInst varInst = this.code((T)new VarInst(stringToken, (Variable)this.instStack.pop()), (Location)((Object)ctx));
        ((InstSet)this.instStack.peek()).addInst(varInst);
        return null;
    }

    @Override
    public T visitRunInst(DataQLParser.RunInstContext ctx) {
        this.visitChildren((RuleNode)ctx);
        RunInst varInst = this.code((T)new RunInst((Variable)this.instStack.pop()), (Location)((Object)ctx));
        ((InstSet)this.instStack.peek()).addInst(varInst);
        return null;
    }

    @Override
    public T visitAssertInst(DataQLParser.AssertInstContext ctx) {
        this.visitChildren((RuleNode)ctx);
        AssertInst varInst = this.code((T)new AssertInst((Variable)this.instStack.pop()), (Location)((Object)ctx));
        ((InstSet)this.instStack.peek()).addInst(varInst);
        return null;
    }

    @Override
    public T visitAnyObject(DataQLParser.AnyObjectContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public T visitIfInst(DataQLParser.IfInstContext ctx) {
        List<DataQLParser.ExprContext> exprList = ctx.expr();
        List<DataQLParser.BlockSetContext> ifBlocks = ctx.blockSet();
        SwitchInst switchInst = this.code((T)new SwitchInst(), (Location)((Object)ctx));
        for (int i = 0; i < ifBlocks.size(); ++i) {
            InstSet instSet;
            if (i < exprList.size()) {
                exprList.get(i).accept(this);
                ifBlocks.get(i).accept(this);
                instSet = (InstSet)this.instStack.pop();
                Variable expr = (Variable)this.instStack.pop();
                if (expr instanceof Expression) {
                    switchInst.addElseif((Expression)expr, instSet);
                    continue;
                }
                switchInst.addElseif(this.code(new AtomExpression(expr), expr), instSet);
                continue;
            }
            ifBlocks.get(i).accept(this);
            instSet = (InstSet)this.instStack.pop();
            switchInst.setElseBlockSet(instSet);
            break;
        }
        ((InstSet)this.instStack.peek()).addInst(switchInst);
        return null;
    }

    @Override
    public T visitBreakInst(DataQLParser.BreakInstContext ctx) {
        TerminalNode breakCodeNode = ctx.INTEGER_NUM();
        IntegerToken breakCodeToken = null;
        if (breakCodeNode != null) {
            int breakCode = Integer.parseInt(breakCodeNode.getText());
            breakCodeToken = this.code((T)new IntegerToken(breakCode), (Location)breakCodeNode);
        } else {
            breakCodeToken = this.code(new IntegerToken(0), ctx.start);
        }
        DataQLParser.AnyObjectContext anyObject = ctx.anyObject();
        anyObject.accept(this);
        Variable variable = (Variable)this.instStack.pop();
        if (ctx.EXIT() != null) {
            ((InstSet)this.instStack.peek()).addInst(this.code((T)new ExitInst(breakCodeToken, variable), (Location)((Object)ctx)));
            return null;
        }
        if (ctx.THROW() != null) {
            ((InstSet)this.instStack.peek()).addInst(this.code((T)new ThrowInst(breakCodeToken, variable), (Location)((Object)ctx)));
            return null;
        }
        if (ctx.RETURN() != null) {
            ((InstSet)this.instStack.peek()).addInst(this.code((T)new ReturnInst(breakCodeToken, variable), (Location)((Object)ctx)));
            return null;
        }
        throw this.newParseException(ctx.start, "missing exit statement.");
    }

    @Override
    public T visitLambdaDef(DataQLParser.LambdaDefContext ctx) {
        LambdaVariable lambdaVariable = this.code((T)new LambdaVariable(), (Location)((Object)ctx));
        List<TerminalNode> identifierList = ctx.IDENTIFIER();
        if (identifierList != null) {
            for (TerminalNode terminalNode : identifierList) {
                String paramName = this.fixIdentifier(terminalNode);
                StringToken paramToken = this.code((T)new StringToken(paramName), (Location)terminalNode);
                lambdaVariable.addParam(paramToken);
            }
        }
        this.instStack.push(lambdaVariable);
        ctx.blockSet().accept(this);
        InstSet instSet = (InstSet)this.instStack.pop();
        ((LambdaVariable)this.instStack.peek()).setMultipleInst(instSet.isMultipleInst());
        ((LambdaVariable)this.instStack.peek()).addInstSet(instSet);
        return null;
    }

    @Override
    public T visitObjectValue(DataQLParser.ObjectValueContext ctx) {
        ObjectVariable objectVariable = this.code((T)new ObjectVariable(), (Location)((Object)ctx));
        this.instStack.push(objectVariable);
        return (T)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public T visitObjectKeyValue(DataQLParser.ObjectKeyValueContext ctx) {
        TerminalNode fieldKeyTerm = ctx.STRING();
        String fieldKey = this.fixString(fieldKeyTerm);
        StringToken fieldKeyToken = this.code((T)new StringToken(fieldKey), (Location)fieldKeyTerm);
        ObjectVariable objectVariable = (ObjectVariable)this.instStack.peek();
        DataQLParser.AnyObjectContext polymericObject = ctx.anyObject();
        if (polymericObject != null) {
            polymericObject.accept(this);
            Variable valueExp = (Variable)this.instStack.pop();
            objectVariable.addField(fieldKeyToken, valueExp);
        } else {
            EnterRouteVariable enterRoute = this.code((T)new EnterRouteVariable(EnterRouteVariable.RouteType.Expr, null), (Location)fieldKeyTerm);
            NameRouteVariable nameRoute = this.code((T)new NameRouteVariable(enterRoute, fieldKeyToken), (Location)fieldKeyTerm);
            objectVariable.addField(fieldKeyToken, nameRoute);
        }
        return null;
    }

    @Override
    public T visitListValue(DataQLParser.ListValueContext ctx) {
        ListVariable listVariable = this.code((T)new ListVariable(), (Location)((Object)ctx));
        List<DataQLParser.AnyObjectContext> polymericList = ctx.anyObject();
        if (polymericList != null) {
            for (DataQLParser.AnyObjectContext polymeric : polymericList) {
                polymeric.accept(this);
                Variable variable = (Variable)this.instStack.pop();
                listVariable.addItem(variable);
            }
        }
        this.instStack.push(listVariable);
        return null;
    }

    @Override
    public T visitStringValue(DataQLParser.StringValueContext ctx) {
        String text = this.fixString(ctx.STRING());
        this.instStack.push(this.code((T)new PrimitiveVariable(text, PrimitiveVariable.ValueType.String), (Location)((Object)ctx)));
        return null;
    }

    @Override
    public T visitNullValue(DataQLParser.NullValueContext ctx) {
        this.instStack.push(this.code((T)new PrimitiveVariable(null, PrimitiveVariable.ValueType.Null), (Location)((Object)ctx)));
        return null;
    }

    @Override
    public T visitBooleanValue(DataQLParser.BooleanValueContext ctx) {
        boolean boolValue = ctx.TRUE() != null;
        this.instStack.push(this.code((T)new PrimitiveVariable(boolValue, PrimitiveVariable.ValueType.Boolean), (Location)((Object)ctx)));
        return null;
    }

    @Override
    public T visitNumberValue(DataQLParser.NumberValueContext ctx) {
        TerminalNode bitNode = ctx.BIT_NUM();
        TerminalNode octNode = ctx.OCT_NUM();
        TerminalNode intNode = ctx.INTEGER_NUM();
        TerminalNode hexNode = ctx.HEX_NUM();
        TerminalNode decimalNode = ctx.DECIMAL_NUM();
        int radix = 10;
        String radixNumber = null;
        TerminalNode atTerm = null;
        if (bitNode != null) {
            radix = 2;
            radixNumber = bitNode.getText();
            radixNumber = radixNumber.charAt(0) == '-' ? "-" + radixNumber.substring(3) : radixNumber.substring(2);
            atTerm = bitNode;
        }
        if (octNode != null) {
            radix = 8;
            radixNumber = octNode.getText();
            radixNumber = radixNumber.charAt(0) == '-' ? "-" + radixNumber.substring(3) : radixNumber.substring(2);
            atTerm = octNode;
        }
        if (intNode != null) {
            radix = 10;
            radixNumber = intNode.getText();
            atTerm = intNode;
        }
        if (hexNode != null) {
            radix = 16;
            radixNumber = hexNode.getText();
            radixNumber = radixNumber.charAt(0) == '-' ? "-" + radixNumber.substring(3) : radixNumber.substring(2);
            atTerm = hexNode;
        }
        if (radixNumber != null) {
            BigInteger bigInt = new BigInteger(radixNumber, radix);
            int bitLength = bigInt.bitLength();
            if (bitLength < 8) {
                this.instStack.push(this.code((T)new PrimitiveVariable(bigInt.byteValue(), PrimitiveVariable.ValueType.Number, radix), (Location)atTerm));
                return null;
            }
            if (bitLength < 16) {
                this.instStack.push(this.code((T)new PrimitiveVariable(bigInt.shortValue(), PrimitiveVariable.ValueType.Number, radix), (Location)atTerm));
                return null;
            }
            if (bitLength < 32) {
                this.instStack.push(this.code((T)new PrimitiveVariable(bigInt.intValue(), PrimitiveVariable.ValueType.Number, radix), (Location)atTerm));
                return null;
            }
            if (bitLength < 64) {
                this.instStack.push(this.code((T)new PrimitiveVariable(bigInt.longValue(), PrimitiveVariable.ValueType.Number, radix), (Location)atTerm));
                return null;
            }
            this.instStack.push(this.code((T)new PrimitiveVariable(bigInt, PrimitiveVariable.ValueType.Number, radix), (Location)atTerm));
            return null;
        }
        BigDecimal bigDec = new BigDecimal(decimalNode.getText());
        atTerm = decimalNode;
        int precisionLength = bigDec.precision();
        if (precisionLength < 8 && !Float.isInfinite(bigDec.floatValue())) {
            this.instStack.push(this.code((T)new PrimitiveVariable(Float.valueOf(bigDec.floatValue()), PrimitiveVariable.ValueType.Number, radix), (Location)atTerm));
            return null;
        }
        if (precisionLength < 16 && !Double.isInfinite(bigDec.doubleValue())) {
            this.instStack.push(this.code((T)new PrimitiveVariable(bigDec.doubleValue(), PrimitiveVariable.ValueType.Number, radix), (Location)atTerm));
            return null;
        }
        this.instStack.push(this.code((T)new PrimitiveVariable(bigDec, PrimitiveVariable.ValueType.Number, radix), (Location)atTerm));
        return null;
    }

    @Override
    public T visitFuncCall(DataQLParser.FuncCallContext ctx) {
        ctx.routeMapping().accept(this);
        RouteVariable routeVariable = (RouteVariable)this.instStack.pop();
        CodeLocation startPos = routeVariable.getStartPosition();
        if (routeVariable.getParent() instanceof EnterRouteVariable) {
            startPos = routeVariable.getParent().getStartPosition();
        }
        CodeLocation endPos = this.code((T)new BlockLocation(), (Location)ctx.RBT()).getEndPosition();
        FunCallRouteVariable funCall = this.code(new FunCallRouteVariable(routeVariable), startPos, endPos);
        List<DataQLParser.AnyObjectContext> paramLists = ctx.anyObject();
        if (paramLists != null) {
            for (DataQLParser.AnyObjectContext param : paramLists) {
                param.accept(this);
                Variable paramVar = (Variable)this.instStack.pop();
                funCall.addParam(paramVar);
            }
        }
        this.instStack.push(funCall);
        DataQLParser.FuncCallResultContext funcCallResult = ctx.funcCallResult();
        if (funcCallResult != null) {
            funcCallResult.accept(this);
        }
        return null;
    }

    @Override
    public T visitFuncCallResult_route1(DataQLParser.FuncCallResult_route1Context ctx) {
        List<DataQLParser.RouteSubscriptContext> subscriptList = ctx.routeSubscript();
        if (subscriptList != null) {
            for (DataQLParser.RouteSubscriptContext context : subscriptList) {
                context.accept(this);
            }
        }
        ctx.routeNameSet().accept(this);
        DataQLParser.FuncCallResultContext funcCallResult = ctx.funcCallResult();
        if (funcCallResult != null) {
            funcCallResult.accept(this);
        }
        return null;
    }

    @Override
    public T visitFuncCallResult_route2(DataQLParser.FuncCallResult_route2Context ctx) {
        DataQLParser.FuncCallResultContext funcCallResult;
        List<DataQLParser.RouteSubscriptContext> subscriptList = ctx.routeSubscript();
        for (DataQLParser.RouteSubscriptContext context : subscriptList) {
            context.accept(this);
        }
        DataQLParser.RouteNameSetContext routeNameSet = ctx.routeNameSet();
        if (routeNameSet != null) {
            ctx.routeNameSet().accept(this);
        }
        if ((funcCallResult = ctx.funcCallResult()) != null) {
            funcCallResult.accept(this);
        }
        return null;
    }

    @Override
    public T visitFuncCallResult_convert(DataQLParser.FuncCallResult_convertContext ctx) {
        RouteVariable routeVariable = (RouteVariable)this.instStack.pop();
        DataQLParser.ListValueContext listValue = ctx.listValue();
        DataQLParser.ObjectValueContext objectValue = ctx.objectValue();
        if (listValue != null) {
            listValue.accept(this);
            ListVariable listVariable = (ListVariable)this.instStack.pop();
            this.instStack.push(this.code((T)new ListFormat(routeVariable, listVariable), (Location)((Object)listValue)));
        } else {
            objectValue.accept(this);
            ObjectVariable objectVariable = (ObjectVariable)this.instStack.pop();
            this.instStack.push(this.code((T)new ObjectFormat(routeVariable, objectVariable), (Location)((Object)objectValue)));
        }
        return null;
    }

    @Override
    public T visitFuncCallResult_call(DataQLParser.FuncCallResult_callContext ctx) {
        RouteVariable routeVariable = (RouteVariable)this.instStack.pop();
        CodeLocation startPos = routeVariable.getStartPosition();
        CodeLocation endPos = this.code((T)new BlockLocation(), (Location)ctx.RBT()).getEndPosition();
        FunCallRouteVariable funCall = this.code(new FunCallRouteVariable(routeVariable), startPos, endPos);
        List<DataQLParser.AnyObjectContext> paramLists = ctx.anyObject();
        if (paramLists != null) {
            for (DataQLParser.AnyObjectContext param : paramLists) {
                param.accept(this);
                Variable paramVar = (Variable)this.instStack.pop();
                funCall.addParam(paramVar);
            }
        }
        this.instStack.push(funCall);
        DataQLParser.FuncCallResultContext funcCallResult = ctx.funcCallResult();
        if (funcCallResult != null) {
            funcCallResult.accept(this);
        }
        return null;
    }

    @Override
    public T visitParamRoute(DataQLParser.ParamRouteContext ctx) {
        DataQLParser.RouteNameSetContext routeNameSet;
        TerminalNode rouTerm = ctx.ROU();
        EnterRouteVariable.SpecialType special = this.specialType(rouTerm, EnterRouteVariable.SpecialType.Special_B);
        TerminalNode identifier = ctx.IDENTIFIER();
        TerminalNode string = ctx.STRING();
        StringToken rouNameToken = null;
        Token enterToken = rouTerm != null ? rouTerm.getSymbol() : ctx.start;
        EnterRouteVariable enter = this.code(new EnterRouteVariable(EnterRouteVariable.RouteType.Params, special), enterToken);
        rouNameToken = identifier != null ? this.code((T)new StringToken(this.fixIdentifier(identifier)), (Location)identifier) : this.code((T)new StringToken(string.getText()), (Location)string);
        this.instStack.push(this.code(new NameRouteVariable(enter, rouNameToken), rouNameToken));
        DataQLParser.RouteSubscriptContext routeSubscript = ctx.routeSubscript();
        if (routeSubscript != null) {
            routeSubscript.accept(this);
        }
        if ((routeNameSet = ctx.routeNameSet()) != null) {
            routeNameSet.accept(this);
        }
        return null;
    }

    @Override
    public T visitSubExprRoute(DataQLParser.SubExprRouteContext ctx) {
        TerminalNode rouTerm = ctx.ROU();
        EnterRouteVariable.SpecialType special = this.specialType(rouTerm, EnterRouteVariable.SpecialType.Special_B);
        Token enterToken = rouTerm != null ? rouTerm.getSymbol() : ctx.start;
        EnterRouteVariable enter = this.code(new EnterRouteVariable(EnterRouteVariable.RouteType.Expr, special), enterToken);
        this.instStack.push(enter);
        List<DataQLParser.RouteSubscriptContext> subscriptContexts = ctx.routeSubscript();
        for (DataQLParser.RouteSubscriptContext subContext : subscriptContexts) {
            subContext.accept(this);
        }
        DataQLParser.RouteNameSetContext routeNameSet = ctx.routeNameSet();
        if (routeNameSet != null) {
            routeNameSet.accept(this);
        }
        return null;
    }

    @Override
    public T visitNameExprRoute(DataQLParser.NameExprRouteContext ctx) {
        TerminalNode rouTerm = ctx.ROU();
        EnterRouteVariable.SpecialType special = this.specialType(rouTerm, EnterRouteVariable.SpecialType.Special_B);
        Token enterToken = rouTerm != null ? rouTerm.getSymbol() : ctx.start;
        EnterRouteVariable enter = this.code(new EnterRouteVariable(EnterRouteVariable.RouteType.Expr, special), enterToken);
        if (ctx.DOT() != null) {
            StringToken stringToken = this.code((T)new StringToken(""), (Location)rouTerm);
            this.instStack.push(this.code((T)new NameRouteVariable(enter, stringToken), (Location)((Object)ctx)));
        } else {
            this.instStack.push(enter);
        }
        DataQLParser.RouteNameSetContext routeNameSet = ctx.routeNameSet();
        if (routeNameSet != null) {
            routeNameSet.accept(this);
        }
        return null;
    }

    @Override
    public T visitExprRoute(DataQLParser.ExprRouteContext ctx) {
        TerminalNode rouTerm = ctx.ROU();
        EnterRouteVariable.SpecialType specialType = this.specialType(rouTerm, EnterRouteVariable.SpecialType.Special_A);
        Token enterToken = rouTerm != null ? rouTerm.getSymbol() : ctx.start;
        EnterRouteVariable enter = this.code(new EnterRouteVariable(EnterRouteVariable.RouteType.Expr, specialType), enterToken);
        this.instStack.push(enter);
        DataQLParser.RouteNameSetContext routeNameSet = ctx.routeNameSet();
        if (routeNameSet != null) {
            routeNameSet.accept(this);
        }
        return null;
    }

    @Override
    public T visitExprFmtRoute(DataQLParser.ExprFmtRouteContext ctx) {
        ctx.routeMapping().accept(this);
        RouteVariable routeVariable = (RouteVariable)this.instStack.pop();
        DataQLParser.ListValueContext listValue = ctx.listValue();
        DataQLParser.ObjectValueContext objectValue = ctx.objectValue();
        if (listValue != null) {
            listValue.accept(this);
            ListVariable listVariable = (ListVariable)this.instStack.pop();
            this.instStack.push(this.code((T)new ListFormat(routeVariable, listVariable), (Location)((Object)listValue)));
        } else {
            objectValue.accept(this);
            ObjectVariable objectVariable = (ObjectVariable)this.instStack.pop();
            this.instStack.push(this.code((T)new ObjectFormat(routeVariable, objectVariable), (Location)((Object)objectValue)));
        }
        return null;
    }

    @Override
    public T visitRouteNameSet(DataQLParser.RouteNameSetContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public T visitRouteName(DataQLParser.RouteNameContext ctx) {
        Object peek = this.instStack.peek();
        RouteVariable parent = null;
        if (peek instanceof RouteVariable) {
            this.instStack.pop();
            parent = (RouteVariable)peek;
        }
        TerminalNode itemNameTerm = ctx.IDENTIFIER();
        StringToken itemNameToken = this.code((T)new StringToken(this.fixIdentifier(itemNameTerm)), (Location)itemNameTerm);
        this.instStack.push(this.code(new NameRouteVariable(parent, itemNameToken), itemNameToken));
        List<DataQLParser.RouteSubscriptContext> subList = ctx.routeSubscript();
        if (subList != null) {
            for (DataQLParser.RouteSubscriptContext subItem : subList) {
                subItem.accept(this);
            }
        }
        return null;
    }

    @Override
    public T visitRouteSubscript(DataQLParser.RouteSubscriptContext ctx) {
        RouteVariable atNode = (RouteVariable)this.instStack.pop();
        TerminalNode intNode = ctx.INTEGER_NUM();
        TerminalNode stringNode = ctx.STRING();
        DataQLParser.ExprContext exprContext = ctx.expr();
        BlockLocation locationInfo = this.code((T)new BlockLocation(), (Location)((Object)ctx));
        CodeLocation startPos = locationInfo.getStartPosition();
        CodeLocation endPos = locationInfo.getEndPosition();
        if (atNode instanceof EnterRouteVariable) {
            startPos = atNode.getStartPosition();
        }
        if (intNode != null) {
            IntegerToken subscriptToken = this.code((T)new IntegerToken(Integer.parseInt(intNode.getText())), (Location)intNode);
            this.instStack.push(this.code(new SubscriptRouteVariable(atNode, subscriptToken), startPos, endPos));
            return null;
        }
        if (stringNode != null) {
            StringToken subscriptToken = this.code((T)new StringToken(this.fixString(stringNode)), (Location)stringNode);
            this.instStack.push(this.code(new SubscriptRouteVariable(atNode, subscriptToken), startPos, endPos));
            return null;
        }
        if (exprContext != null) {
            exprContext.accept(this);
            Expression expr = (Expression)this.instStack.pop();
            this.instStack.push(this.code(new SubscriptRouteVariable(atNode, expr), startPos, endPos));
            return null;
        }
        throw this.newParseException(ctx.start, "parser failed -> visitRouteSubscript.");
    }

    @Override
    public T visitPrivilegeExpr(DataQLParser.PrivilegeExprContext ctx) {
        DataQLParser.ExprContext expr = ctx.expr();
        expr.accept(this);
        this.instStack.push(this.code((T)new PrivilegeExpression((Expression)this.instStack.pop()), (Location)((Object)ctx)));
        return null;
    }

    @Override
    public T visitUnaryExpr(DataQLParser.UnaryExprContext ctx) {
        TerminalNode unaryOper = null;
        unaryOper = this.operSwitch(unaryOper, ctx.NOT());
        unaryOper = this.operSwitch(unaryOper, ctx.MINUS());
        unaryOper = this.operSwitch(unaryOper, ctx.PLUS());
        ctx.expr().accept(this);
        Expression expr = (Expression)this.instStack.pop();
        SymbolToken symbolToken = this.code((T)new SymbolToken(unaryOper.getText()), (Location)unaryOper);
        this.instStack.push(this.code((T)new UnaryExpression(expr, symbolToken), (Location)((Object)ctx)));
        return null;
    }

    @Override
    public T visitDyadicExpr_A(DataQLParser.DyadicExpr_AContext ctx) {
        TerminalNode dyadicOper = null;
        dyadicOper = this.operSwitch(dyadicOper, ctx.MUL());
        dyadicOper = this.operSwitch(dyadicOper, ctx.DIV());
        dyadicOper = this.operSwitch(dyadicOper, ctx.DIV2());
        dyadicOper = this.operSwitch(dyadicOper, ctx.MOD());
        ctx.expr(0).accept(this);
        ctx.expr(1).accept(this);
        Expression expr2 = (Expression)this.instStack.pop();
        Expression expr1 = (Expression)this.instStack.pop();
        SymbolToken symbolToken = this.code((T)new SymbolToken(dyadicOper.getText()), (Location)dyadicOper);
        this.instStack.push(this.code((T)new DyadicExpression(expr1, symbolToken, expr2), (Location)((Object)ctx)));
        return null;
    }

    @Override
    public T visitDyadicExpr_B(DataQLParser.DyadicExpr_BContext ctx) {
        TerminalNode dyadicOper = null;
        dyadicOper = this.operSwitch(dyadicOper, ctx.PLUS());
        dyadicOper = this.operSwitch(dyadicOper, ctx.MINUS());
        ctx.expr(0).accept(this);
        ctx.expr(1).accept(this);
        Expression expr2 = (Expression)this.instStack.pop();
        Expression expr1 = (Expression)this.instStack.pop();
        SymbolToken symbolToken = this.code((T)new SymbolToken(dyadicOper.getText()), (Location)dyadicOper);
        this.instStack.push(this.code((T)new DyadicExpression(expr1, symbolToken, expr2), (Location)((Object)ctx)));
        return null;
    }

    @Override
    public T visitDyadicExpr_C(DataQLParser.DyadicExpr_CContext ctx) {
        TerminalNode dyadicOper = null;
        dyadicOper = this.operSwitch(dyadicOper, ctx.AND());
        dyadicOper = this.operSwitch(dyadicOper, ctx.OR());
        dyadicOper = this.operSwitch(dyadicOper, ctx.XOR());
        dyadicOper = this.operSwitch(dyadicOper, ctx.LSHIFT());
        dyadicOper = this.operSwitch(dyadicOper, ctx.RSHIFT());
        dyadicOper = this.operSwitch(dyadicOper, ctx.RSHIFT2());
        ctx.expr(0).accept(this);
        ctx.expr(1).accept(this);
        Expression expr2 = (Expression)this.instStack.pop();
        Expression expr1 = (Expression)this.instStack.pop();
        SymbolToken symbolToken = this.code((T)new SymbolToken(dyadicOper.getText()), (Location)dyadicOper);
        this.instStack.push(this.code((T)new DyadicExpression(expr1, symbolToken, expr2), (Location)((Object)ctx)));
        return null;
    }

    @Override
    public T visitDyadicExpr_D(DataQLParser.DyadicExpr_DContext ctx) {
        TerminalNode dyadicOper = null;
        dyadicOper = this.operSwitch(dyadicOper, ctx.GT());
        dyadicOper = this.operSwitch(dyadicOper, ctx.GE());
        dyadicOper = this.operSwitch(dyadicOper, ctx.NE());
        dyadicOper = this.operSwitch(dyadicOper, ctx.EQ());
        dyadicOper = this.operSwitch(dyadicOper, ctx.LE());
        dyadicOper = this.operSwitch(dyadicOper, ctx.LT());
        ctx.expr(0).accept(this);
        ctx.expr(1).accept(this);
        Expression expr2 = (Expression)this.instStack.pop();
        Expression expr1 = (Expression)this.instStack.pop();
        SymbolToken symbolToken = this.code((T)new SymbolToken(dyadicOper.getText()), (Location)dyadicOper);
        this.instStack.push(this.code((T)new DyadicExpression(expr1, symbolToken, expr2), (Location)((Object)ctx)));
        return null;
    }

    @Override
    public T visitDyadicExpr_E(DataQLParser.DyadicExpr_EContext ctx) {
        TerminalNode dyadicOper = null;
        dyadicOper = this.operSwitch(dyadicOper, ctx.SC_OR());
        dyadicOper = this.operSwitch(dyadicOper, ctx.SC_AND());
        ctx.expr(0).accept(this);
        ctx.expr(1).accept(this);
        Expression expr2 = (Expression)this.instStack.pop();
        Expression expr1 = (Expression)this.instStack.pop();
        SymbolToken symbolToken = this.code((T)new SymbolToken(dyadicOper.getText()), (Location)dyadicOper);
        this.instStack.push(this.code((T)new DyadicExpression(expr1, symbolToken, expr2), (Location)((Object)ctx)));
        return null;
    }

    @Override
    public T visitTernaryExpr(DataQLParser.TernaryExprContext ctx) {
        this.visitChildren((RuleNode)ctx);
        Expression expr3 = (Expression)this.instStack.pop();
        Expression expr2 = (Expression)this.instStack.pop();
        Expression expr1 = (Expression)this.instStack.pop();
        this.instStack.push(this.code((T)new TernaryExpression(expr1, expr2, expr3), (Location)((Object)ctx)));
        return null;
    }

    @Override
    public T visitAtomExpr(DataQLParser.AtomExprContext ctx) {
        this.visitChildren((RuleNode)ctx);
        if (this.instStack.peek() instanceof Expression) {
            return null;
        }
        Variable var = (Variable)this.instStack.pop();
        this.instStack.push(this.code((T)new AtomExpression(var), (Location)((Object)ctx)));
        return null;
    }

    @Override
    public T visitExtBlock(DataQLParser.ExtBlockContext ctx) {
        TerminalNode fragmentNameToke = ctx.IDENTIFIER();
        String fragmentName = this.fixIdentifier(fragmentNameToke);
        StringBuilder fragmentString = new StringBuilder();
        List<TerminalNode> chars = ctx.CHAR();
        chars.forEach(terminalNode -> fragmentString.append(terminalNode.getText()));
        boolean isBatch = ctx.LSBT() != null;
        StringToken fragmentNameToken = this.code((T)new StringToken(fragmentName), (Location)fragmentNameToke);
        StringToken fragmentStringToken = this.code(new StringToken(fragmentString.toString()), chars);
        FragmentVariable fragmentVariable = this.code((T)new FragmentVariable(fragmentNameToken, fragmentStringToken, isBatch), (Location)((Object)ctx));
        DataQLParser.ExtParamsContext paramsContext = ctx.extParams();
        if (paramsContext != null) {
            for (TerminalNode terminalNode2 : paramsContext.IDENTIFIER()) {
                StringToken paramNameToken = this.code((T)new StringToken(this.fixIdentifier(terminalNode2)), (Location)terminalNode2);
                fragmentVariable.getParamList().add(paramNameToken);
            }
        }
        this.instStack.push(fragmentVariable);
        return null;
    }

    @Override
    public T visitExtParams(DataQLParser.ExtParamsContext ctx) {
        return null;
    }

    private EnterRouteVariable.SpecialType specialType(TerminalNode rou, EnterRouteVariable.SpecialType defaultType) {
        if (rou == null) {
            return defaultType;
        }
        String rouType = rou.getText();
        if ("#".equals(rouType)) {
            return EnterRouteVariable.SpecialType.Special_A;
        }
        if ("$".equals(rouType)) {
            return EnterRouteVariable.SpecialType.Special_B;
        }
        if ("@".equals(rouType)) {
            return EnterRouteVariable.SpecialType.Special_C;
        }
        throw this.newParseException(rou.getSymbol(), "rouType '" + rouType + "' is not supported");
    }

    private TerminalNode operSwitch(TerminalNode first, TerminalNode second) {
        return first != null ? first : second;
    }

    private QueryParseException newParseException(Token token, String errorMessage) {
        return new QueryParseException(token.getLine(), token.getStartIndex(), errorMessage);
    }

    private String fixIdentifier(TerminalNode identifierNode) {
        String string = identifierNode.getText();
        if (string.charAt(0) == '`') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private String fixString(TerminalNode stringNode) {
        String nodeText = stringNode.getText();
        return nodeText.substring(1, nodeText.length() - 1);
    }
}

