/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.parser.ast.expr;

import java.io.IOException;
import net.hasor.dataql.Hints;
import net.hasor.dataql.parser.ast.AstVisitor;
import net.hasor.dataql.parser.ast.Expression;
import net.hasor.dataql.parser.ast.FormatWriter;
import net.hasor.dataql.parser.ast.InstVisitorContext;
import net.hasor.dataql.parser.location.BlockLocation;

public class PrivilegeExpression
extends BlockLocation
implements Expression {
    private final Expression expression;

    public PrivilegeExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public String toString() {
        return "( " + this.expression.toString() + " )";
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                PrivilegeExpression.this.expression.accept(astVisitor);
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        if (this.expression instanceof PrivilegeExpression) {
            this.expression.doFormat(depth, formatOption, writer);
        } else {
            writer.write("(");
            this.expression.doFormat(depth, formatOption, writer);
            writer.write(")");
        }
    }
}

