/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.parser.ast.expr;

import java.io.IOException;
import net.hasor.dataql.Hints;
import net.hasor.dataql.parser.ast.AstVisitor;
import net.hasor.dataql.parser.ast.Expression;
import net.hasor.dataql.parser.ast.FormatWriter;
import net.hasor.dataql.parser.ast.InstVisitorContext;
import net.hasor.dataql.parser.location.BlockLocation;

public class TernaryExpression
extends BlockLocation
implements Expression {
    private final Expression testExpression;
    private final Expression thenExpression;
    private final Expression elseExpression;

    public TernaryExpression(Expression testExp, Expression thenExp, Expression elseExp) {
        this.testExpression = testExp;
        this.thenExpression = thenExp;
        this.elseExpression = elseExp;
    }

    public Expression getTestExpression() {
        return this.testExpression;
    }

    public Expression getThenExpression() {
        return this.thenExpression;
    }

    public Expression getElseExpression() {
        return this.elseExpression;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                TernaryExpression.this.testExpression.accept(astVisitor);
                TernaryExpression.this.thenExpression.accept(astVisitor);
                TernaryExpression.this.elseExpression.accept(astVisitor);
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        this.testExpression.doFormat(depth, formatOption, writer);
        writer.write(" ? ");
        this.thenExpression.doFormat(depth, formatOption, writer);
        writer.write(" : ");
        this.elseExpression.doFormat(depth, formatOption, writer);
    }
}

