/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.parser.ast.inst;

import java.io.IOException;
import net.hasor.dataql.Hints;
import net.hasor.dataql.parser.ast.AstVisitor;
import net.hasor.dataql.parser.ast.FormatWriter;
import net.hasor.dataql.parser.ast.Inst;
import net.hasor.dataql.parser.ast.InstVisitorContext;
import net.hasor.dataql.parser.ast.Variable;
import net.hasor.dataql.parser.ast.token.IntegerToken;
import net.hasor.dataql.parser.ast.value.LambdaVariable;
import net.hasor.dataql.parser.location.BlockLocation;
import net.hasor.utils.StringUtils;

public class ExitInst
extends BlockLocation
implements Inst {
    private final IntegerToken exitCode;
    private final Variable exitData;

    public ExitInst(IntegerToken exitCode, Variable exitData) {
        this.exitCode = exitCode;
        this.exitData = exitData;
    }

    public IntegerToken getExitCode() {
        return this.exitCode;
    }

    public Variable getExitData() {
        return this.exitData;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                ExitInst.this.exitData.accept(astVisitor);
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        String fixedString = StringUtils.repeat((char)' ', (int)(depth * 4));
        if (this.exitCode.getValue() != 0) {
            writer.write(fixedString + String.format("exit %s, ", this.exitCode.getValue()));
        } else {
            writer.write(fixedString + "exit ");
        }
        this.exitData.doFormat(depth + 1, formatOption, writer);
        writer.write(this.exitData instanceof LambdaVariable ? "\n" : ";\n");
    }
}

