/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.parser.ast.inst;

import java.io.IOException;
import net.hasor.dataql.Hints;
import net.hasor.dataql.parser.ast.AstVisitor;
import net.hasor.dataql.parser.ast.FormatWriter;
import net.hasor.dataql.parser.ast.Inst;
import net.hasor.dataql.parser.ast.InstVisitorContext;
import net.hasor.dataql.parser.ast.token.StringToken;
import net.hasor.dataql.parser.ast.value.PrimitiveVariable;
import net.hasor.dataql.parser.location.BlockLocation;
import net.hasor.utils.StringUtils;

public class HintInst
extends BlockLocation
implements Inst {
    private final StringToken hint;
    private final PrimitiveVariable value;

    public HintInst(StringToken hint, PrimitiveVariable value) {
        this.hint = hint;
        this.value = value;
    }

    public StringToken getHint() {
        return this.hint;
    }

    public PrimitiveVariable getValue() {
        return this.value;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                HintInst.this.value.accept(astVisitor);
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        String fixedString = StringUtils.repeat((char)' ', (int)(depth * 4));
        String opt = fixedString + "hint " + this.hint.getValue() + " = ";
        writer.write(opt);
        this.value.doFormat(depth + 1, formatOption, writer);
        writer.write(";\n");
    }
}

