/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.parser.ast.inst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.hasor.dataql.Hints;
import net.hasor.dataql.parser.ast.AstVisitor;
import net.hasor.dataql.parser.ast.FormatWriter;
import net.hasor.dataql.parser.ast.Inst;
import net.hasor.dataql.parser.ast.InstVisitorContext;
import net.hasor.dataql.parser.ast.inst.HintInst;
import net.hasor.dataql.parser.location.BlockLocation;
import net.hasor.dataql.parser.location.CodeLocation;

public class InstSet
extends ArrayList<Inst>
implements Inst {
    private final BlockLocation astBasic = new BlockLocation();
    private final List<HintInst> optionSet = new ArrayList<HintInst>();
    private boolean multipleInst;

    public InstSet(boolean multipleInst) {
        this.multipleInst = multipleInst;
    }

    public void addOptionInst(HintInst inst) {
        this.optionSet.add(Objects.requireNonNull(inst, "option inst npe."));
    }

    public List<HintInst> getOptionSet() {
        return this.optionSet;
    }

    public void setMultipleInst(boolean multipleInst) {
        this.multipleInst = multipleInst;
    }

    public boolean isMultipleInst() {
        return this.multipleInst;
    }

    public void addInstSet(InstSet inst) {
        this.addAll(inst);
    }

    public void addInst(Inst inst) {
        if (inst != null) {
            this.add(inst);
        }
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                for (HintInst hintInst : InstSet.this.getOptionSet()) {
                    hintInst.accept(astVisitor);
                }
                for (Inst inst : InstSet.this) {
                    inst.accept(astVisitor);
                }
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        int size = this.size();
        if (this.getOptionSet().isEmpty() && size <= 1 && !this.isMultipleInst()) {
            if (size == 0) {
                return;
            }
            Inst inst = (Inst)this.get(0);
            inst.doFormat(depth, formatOption, writer);
            return;
        }
        writer.write("{\n");
        for (HintInst opt : this.getOptionSet()) {
            opt.doFormat(depth + 1, formatOption, writer);
        }
        if (!this.getOptionSet().isEmpty()) {
            writer.write("\n");
        }
        for (int i = 0; i < this.size(); ++i) {
            Inst inst = (Inst)this.get(i);
            inst.doFormat(depth + 1, formatOption, writer);
            if (!(inst instanceof InstSet)) continue;
            writer.write("\n");
        }
        writer.write("}");
    }

    @Override
    public CodeLocation getStartPosition() {
        return this.astBasic.getStartPosition();
    }

    @Override
    public CodeLocation getEndPosition() {
        return this.astBasic.getEndPosition();
    }

    @Override
    public void setStartPosition(CodeLocation codePosition) {
        this.astBasic.setStartPosition(codePosition);
    }

    @Override
    public void setEndPosition(CodeLocation codePosition) {
        this.astBasic.setEndPosition(codePosition);
    }
}

