/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.parser.ast.inst;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.hasor.dataql.parser.QueryModel;
import net.hasor.dataql.parser.ast.AstVisitor;
import net.hasor.dataql.parser.ast.FormatWriter;
import net.hasor.dataql.parser.ast.Inst;
import net.hasor.dataql.parser.ast.InstVisitorContext;
import net.hasor.dataql.parser.ast.inst.HintInst;
import net.hasor.dataql.parser.ast.inst.ImportInst;
import net.hasor.dataql.parser.ast.inst.InstSet;
import net.hasor.dataql.runtime.HintsSet;

public class RootBlockSet
extends InstSet
implements QueryModel {
    private final List<ImportInst> importSet = new ArrayList<ImportInst>();

    public RootBlockSet() {
        super(true);
    }

    public void addImportInst(ImportInst inst) {
        this.importSet.add(Objects.requireNonNull(inst, "import inst npe."));
    }

    public List<ImportInst> getImportSet() {
        return this.importSet;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                for (HintInst hintInst : RootBlockSet.this.getOptionSet()) {
                    hintInst.accept(astVisitor);
                }
                for (ImportInst importInst : RootBlockSet.this.importSet) {
                    importInst.accept(astVisitor);
                }
                for (Inst inst : RootBlockSet.this) {
                    inst.accept(astVisitor);
                }
            }
        });
    }

    @Override
    public void toQueryString(HintsSet formatOptions, Writer writer) throws IOException {
        FormatWriter formatWriter = new FormatWriter(writer);
        formatOptions = formatOptions == null ? new HintsSet() : formatOptions;
        for (HintInst hintInst : this.getOptionSet()) {
            hintInst.doFormat(0, formatOptions, formatWriter);
        }
        for (ImportInst importInst : this.importSet) {
            importInst.doFormat(0, formatOptions, formatWriter);
        }
        writer.write("\n");
        for (int i = 0; i < this.size(); ++i) {
            Inst inst = (Inst)this.get(i);
            inst.doFormat(0, formatOptions, formatWriter);
            if (!(inst instanceof InstSet)) continue;
            writer.write("\n");
        }
        writer.flush();
    }
}

