/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.parser.ast.inst;

import java.io.IOException;
import net.hasor.dataql.Hints;
import net.hasor.dataql.parser.ast.AstVisitor;
import net.hasor.dataql.parser.ast.FormatWriter;
import net.hasor.dataql.parser.ast.Inst;
import net.hasor.dataql.parser.ast.InstVisitorContext;
import net.hasor.dataql.parser.ast.Variable;
import net.hasor.dataql.parser.ast.token.IntegerToken;
import net.hasor.dataql.parser.ast.value.LambdaVariable;
import net.hasor.dataql.parser.location.BlockLocation;
import net.hasor.utils.StringUtils;

public class ThrowInst
extends BlockLocation
implements Inst {
    private final IntegerToken errorCode;
    private final Variable throwData;

    public ThrowInst(IntegerToken exitCode, Variable exitData) {
        this.errorCode = exitCode;
        this.throwData = exitData;
    }

    public IntegerToken getErrorCode() {
        return this.errorCode;
    }

    public Variable getThrowData() {
        return this.throwData;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                ThrowInst.this.throwData.accept(astVisitor);
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        String fixedString = StringUtils.repeat((char)' ', (int)(depth * 4));
        if (this.errorCode.getValue() != 0) {
            writer.write(fixedString + String.format("throw %s, ", this.errorCode.getValue()));
        } else {
            writer.write(fixedString + "throw ");
        }
        this.throwData.doFormat(depth + 1, formatOption, writer);
        writer.write(this.throwData instanceof LambdaVariable ? "\n" : ";\n");
    }
}

