/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.parser.ast.value;

import java.io.IOException;
import net.hasor.dataql.Hints;
import net.hasor.dataql.parser.ast.AstVisitor;
import net.hasor.dataql.parser.ast.FormatWriter;
import net.hasor.dataql.parser.ast.InstVisitorContext;
import net.hasor.dataql.parser.ast.RouteVariable;
import net.hasor.dataql.parser.ast.Variable;
import net.hasor.dataql.parser.ast.token.StringToken;
import net.hasor.dataql.parser.ast.value.EnterRouteVariable;
import net.hasor.dataql.parser.location.BlockLocation;
import net.hasor.utils.StringUtils;

public class NameRouteVariable
extends BlockLocation
implements Variable,
RouteVariable {
    private final RouteVariable parent;
    private final StringToken name;

    public NameRouteVariable(RouteVariable parent, StringToken name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public RouteVariable getParent() {
        return this.parent;
    }

    public StringToken getName() {
        return this.name;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        if (this.parent != null) {
            this.parent.accept(astVisitor);
        }
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        EnterRouteVariable.RouteType routeType = null;
        EnterRouteVariable.SpecialType specialType = EnterRouteVariable.SpecialType.Special_A;
        if (this.parent instanceof EnterRouteVariable) {
            routeType = ((EnterRouteVariable)this.parent).getRouteType();
            specialType = ((EnterRouteVariable)this.parent).getSpecialType();
            if (specialType == null) {
                specialType = EnterRouteVariable.SpecialType.Special_A;
            }
        }
        if (EnterRouteVariable.RouteType.Params == routeType) {
            writer.write(specialType.getCode() + "{");
        }
        this.parent.doFormat(depth, formatOption, writer);
        if (this.parent instanceof EnterRouteVariable) {
            if (StringUtils.isBlank((String)this.name.getValue())) {
                EnterRouteVariable.SpecialType special = ((EnterRouteVariable)this.parent).getSpecialType();
                if (special != EnterRouteVariable.SpecialType.Special_A) {
                    writer.write(((EnterRouteVariable)this.parent).getSpecialType().getCode());
                }
            } else {
                if (EnterRouteVariable.RouteType.Params != routeType && EnterRouteVariable.SpecialType.Special_A != specialType) {
                    writer.write(specialType.getCode());
                }
                writer.write(this.name.getValue());
            }
        } else if (this.parent instanceof NameRouteVariable && StringUtils.isBlank((String)((NameRouteVariable)this.parent).name.getValue())) {
            writer.write(this.name.getValue());
        } else {
            writer.write("." + this.name.getValue());
        }
        if (EnterRouteVariable.RouteType.Params == routeType) {
            writer.write("}");
        }
    }
}

