/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.parser.ast.value;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hasor.dataql.Hints;
import net.hasor.dataql.parser.ast.AstVisitor;
import net.hasor.dataql.parser.ast.FormatWriter;
import net.hasor.dataql.parser.ast.Inst;
import net.hasor.dataql.parser.ast.InstVisitorContext;
import net.hasor.dataql.parser.ast.RouteVariable;
import net.hasor.dataql.parser.ast.Variable;
import net.hasor.dataql.parser.ast.expr.AtomExpression;
import net.hasor.dataql.parser.ast.token.StringToken;
import net.hasor.dataql.parser.ast.value.EnterRouteVariable;
import net.hasor.dataql.parser.ast.value.NameRouteVariable;
import net.hasor.dataql.parser.location.BlockLocation;
import net.hasor.utils.StringUtils;

public class ObjectVariable
extends BlockLocation
implements Inst,
Variable {
    private final List<String> fieldSort = new ArrayList<String>();
    private final String objectType;
    private final Map<String, StringToken> objectKey = new HashMap<String, StringToken>();
    private final Map<String, Variable> objectData = new HashMap<String, Variable>();

    public ObjectVariable() {
        this.objectType = "";
    }

    public void addField(StringToken fieldName, Variable valueExp) {
        String nameValue = fieldName.getValue();
        if (StringUtils.isBlank((String)nameValue) || this.fieldSort.contains(nameValue)) {
            return;
        }
        this.fieldSort.add(nameValue);
        this.objectKey.put(nameValue, fieldName);
        this.objectData.put(nameValue, valueExp);
    }

    public List<String> getFieldSort() {
        return this.fieldSort;
    }

    public Map<String, StringToken> getObjectKeys() {
        return this.objectKey;
    }

    public Map<String, Variable> getObjectValues() {
        return this.objectData;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                for (Variable var : ObjectVariable.this.objectData.values()) {
                    var.accept(astVisitor);
                }
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        if (this.objectData.isEmpty()) {
            writer.write("{}");
            return;
        }
        depth = depth == 0 ? 1 : depth;
        String fixedString = StringUtils.repeat((char)' ', (int)(depth * 4));
        writer.write("{\n");
        for (int i = 0; i < this.fieldSort.size(); ++i) {
            if (i > 0) {
                writer.write(",\n");
            }
            String key = this.fieldSort.get(i);
            String newKey = key.replace(String.valueOf('\"'), "\\\"");
            writer.write(fixedString + '\"' + newKey + '\"');
            Variable variable = this.objectData.get(key);
            if (variable instanceof AtomExpression) {
                variable = ((AtomExpression)variable).getVariableExpression();
            }
            if (variable instanceof NameRouteVariable) {
                EnterRouteVariable.SpecialType specialType;
                NameRouteVariable nameRouteVariable = (NameRouteVariable)variable;
                if (!key.equals(nameRouteVariable.getName().getValue())) {
                    writer.write(" : ");
                    variable.doFormat(depth + 1, formatOption, writer);
                    continue;
                }
                RouteVariable tempParent = nameRouteVariable.getParent();
                if (tempParent instanceof NameRouteVariable && StringUtils.isBlank((String)((NameRouteVariable)tempParent).getName().getValue())) {
                    tempParent = tempParent.getParent();
                }
                if (!(tempParent instanceof EnterRouteVariable) || (specialType = ((EnterRouteVariable)tempParent).getSpecialType()) == null || specialType == EnterRouteVariable.SpecialType.Special_A) continue;
                writer.write(" : ");
                variable.doFormat(depth + 1, formatOption, writer);
                continue;
            }
            writer.write(" : ");
            if (variable instanceof EnterRouteVariable) {
                writer.write(((EnterRouteVariable)variable).getSpecialType().getCode());
                continue;
            }
            variable.doFormat(depth + 1, formatOption, writer);
        }
        writer.write("\n" + StringUtils.repeat((char)' ', (int)((depth - 1) * 4)) + "}");
    }
}

