/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.parser.ast.value;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.hasor.dataql.Hints;
import net.hasor.dataql.parser.ast.AstVisitor;
import net.hasor.dataql.parser.ast.FormatWriter;
import net.hasor.dataql.parser.ast.Inst;
import net.hasor.dataql.parser.ast.InstVisitorContext;
import net.hasor.dataql.parser.ast.Variable;
import net.hasor.dataql.parser.location.BlockLocation;
import net.hasor.utils.NumberUtils;

public class PrimitiveVariable
extends BlockLocation
implements Variable,
Inst {
    private final Object value;
    private final ValueType valueType;
    private final int radix;

    public PrimitiveVariable(Object value, ValueType valueType) {
        this.value = value;
        this.valueType = valueType;
        this.radix = 10;
    }

    public PrimitiveVariable(Object value, ValueType valueType, int radix) {
        this.value = value;
        this.valueType = valueType;
        this.radix = radix;
    }

    public Object getValue() {
        return this.value;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public String toString() {
        return "Primitive - '" + this.value + "'";
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
            }
        });
    }

    private String radix2String(int radix) {
        if (radix == 2) {
            return "0b";
        }
        if (radix == 8) {
            return "0o";
        }
        if (radix == 10) {
            return "";
        }
        if (radix == 16) {
            return "0x";
        }
        throw new RuntimeException("radix not support.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        if (this.valueType == ValueType.Null) {
            writer.write("null");
            return;
        } else if (this.valueType == ValueType.String) {
            String newValue = this.value.toString().replace(String.valueOf('\"'), "\\\"");
            writer.write('\"' + newValue + '\"');
            return;
        } else if (this.value instanceof Number) {
            Number number = (Number)this.value;
            if (NumberUtils.isByteType(number.getClass()) || NumberUtils.isShortType(number.getClass()) || NumberUtils.isIntType(number.getClass()) || NumberUtils.isLongType(number.getClass())) {
                long longValue = number.longValue();
                int beginSub = longValue < 0L ? 1 : 0;
                String string = this.radix2String(this.radix) + Long.toString(longValue, this.radix).substring(beginSub);
                if (beginSub > 0) {
                    writer.write("-" + string);
                    return;
                } else {
                    writer.write(string);
                }
                return;
            } else if (number instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)number;
                int beginSub = bigInteger.compareTo(BigInteger.ZERO) < 0 ? 1 : 0;
                String string = this.radix2String(this.radix) + ((BigInteger)number).toString(this.radix).substring(beginSub);
                if (beginSub > 0) {
                    writer.write("-" + string);
                    return;
                } else {
                    writer.write(string);
                }
                return;
            } else if (NumberUtils.isFloatType(number.getClass()) || NumberUtils.isDoubleType(number.getClass())) {
                writer.write(Double.toString(number.doubleValue()));
                return;
            } else {
                if (!(number instanceof BigDecimal)) throw new RuntimeException("not support number type.");
                writer.write(number.toString());
            }
            return;
        } else {
            writer.write(this.value.toString());
        }
    }

    public static enum ValueType {
        Boolean,
        Number,
        String,
        Null;

    }
}

