/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.parser.location;

public final class CodeLocation {
    private final int lineNumber;
    private final int columnNumber;

    public CodeLocation() {
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public CodeLocation(int lineNumber, int columnNumber) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String toString() {
        String columnNumStr;
        if (this.lineNumber <= 0 && this.columnNumber < 0) {
            return "Unknown";
        }
        String lineNumStr = this.lineNumber >= 0 ? String.valueOf(this.lineNumber) : "Unknown";
        String string = columnNumStr = this.columnNumber >= 0 ? String.valueOf(this.columnNumber) : "Unknown";
        if ("Unknown".equalsIgnoreCase(columnNumStr)) {
            return lineNumStr;
        }
        return lineNumStr + ":" + columnNumStr;
    }
}

