/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime;

import java.util.Map;
import java.util.Stack;
import net.hasor.dataql.CustomizeScope;
import net.hasor.dataql.Finder;
import net.hasor.dataql.FragmentProcess;
import net.hasor.dataql.Hints;
import net.hasor.dataql.runtime.HintsSet;
import net.hasor.dataql.runtime.operator.OperatorManager;
import net.hasor.dataql.runtime.operator.OperatorProcess;

public class InsetProcessContext
implements CustomizeScope {
    private static final OperatorManager opeManager = OperatorManager.defaultManager();
    private final long startTime = System.currentTimeMillis();
    private final CustomizeScope customizeScope;
    private final Finder finder;
    private final Stack<HintsSet> hintStack = new Stack();

    InsetProcessContext(CustomizeScope customizeScope, Finder finder) {
        if (finder == null) {
            finder = new Finder(){};
        }
        this.customizeScope = customizeScope;
        this.finder = finder;
        this.hintStack.push(new HintsSet());
    }

    public Hints currentHints() {
        return this.hintStack.peek();
    }

    public void createHintStack() {
        HintsSet hintsSet = new HintsSet();
        hintsSet.setHints(this.hintStack.peek());
        this.hintStack.push(hintsSet);
    }

    public void dropHintStack() {
        if (this.hintStack.size() > 1) {
            this.hintStack.pop();
        }
    }

    public long executionTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public Finder getFinder() {
        return this.finder;
    }

    public OperatorProcess findUnaryOperator(String unarySymbol, Class<?> fstType) {
        return opeManager.findUnaryProcess(unarySymbol, fstType);
    }

    public OperatorProcess findDyadicOperator(String dyadicSymbol, Class<?> fstType, Class<?> secType) {
        return opeManager.findDyadicProcess(dyadicSymbol, fstType, secType);
    }

    @Override
    public Map<String, ?> findCustomizeEnvironment(String symbol) {
        if (this.customizeScope == null) {
            return null;
        }
        return this.customizeScope.findCustomizeEnvironment(symbol);
    }

    public Object loadObject(String udfType) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> loadClass = classLoader.loadClass(udfType);
        return this.finder.findBean(loadClass);
    }

    public FragmentProcess findFragmentProcess(String fragmentType) {
        return this.finder.findFragmentProcess(fragmentType);
    }
}

